/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.EncryptedLeaseSet;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.MetaLeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.i2cp.CreateLeaseSetMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.ByteArrayStream;

public class CreateLeaseSet2Message
extends CreateLeaseSetMessage {
    public static final int MESSAGE_TYPE = 41;
    private List<PrivateKey> _privateKeys;

    public List<PrivateKey> getPrivateKeys() {
        if (this._privateKeys != null) {
            return this._privateKeys;
        }
        PrivateKey pk = this.getPrivateKey();
        if (pk != null) {
            return Collections.singletonList(pk);
        }
        return null;
    }

    public void addPrivateKey(PrivateKey key) {
        PrivateKey pk = this.getPrivateKey();
        if (pk == null) {
            this.setPrivateKey(key);
        } else {
            if (this._privateKeys == null) {
                this._privateKeys = new ArrayList<PrivateKey>(4);
                this._privateKeys.add(pk);
            }
            this._privateKeys.add(key);
        }
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            int type = in.read();
            if (type == 1) {
                this._leaseSet = new LeaseSet();
            } else if (type == 3) {
                this._leaseSet = new LeaseSet2();
            } else if (type == 5) {
                this._leaseSet = new EncryptedLeaseSet();
            } else if (type == 7) {
                this._leaseSet = new MetaLeaseSet();
            } else {
                if (type == -1) {
                    throw new EOFException("EOF reading LS type");
                }
                throw new I2CPMessageException("Unsupported Leaseset type: " + type);
            }
            this._leaseSet.readBytes(in);
            if (type != 7) {
                SigType stype = this._leaseSet.getSignature().getType();
                if (stype == null) {
                    throw new I2CPMessageException("Unsupported sig type");
                }
                if (type == 3 || type == 5) {
                    LeaseSet2 ls2 = (LeaseSet2)this._leaseSet;
                    List<PublicKey> pks = ls2.getEncryptionKeys();
                    int numkeys = in.read();
                    if (pks != null && numkeys != pks.size()) {
                        throw new I2CPMessageException("Wrong number of privkeys");
                    }
                    for (int i = 0; i < numkeys; ++i) {
                        EncType etype;
                        int encType = (int)DataHelper.readLong(in, 2);
                        int encLen = (int)DataHelper.readLong(in, 2);
                        if (pks != null) {
                            etype = pks.get(i).getType();
                            if (etype == null) {
                                throw new I2CPMessageException("Unsupported encryption type: " + encType);
                            }
                            if (encType != etype.getCode()) {
                                throw new I2CPMessageException("Enc type mismatch");
                            }
                            if (encLen != etype.getPrivkeyLen()) {
                                throw new I2CPMessageException("Enc type bad length");
                            }
                        } else {
                            etype = EncType.getByCode(encType);
                            if (etype == null) {
                                throw new I2CPMessageException("Unsupported encryption type: " + encType);
                            }
                            if (encLen != etype.getPrivkeyLen()) {
                                throw new I2CPMessageException("Enc type bad length");
                            }
                        }
                        PrivateKey priv = new PrivateKey(etype);
                        priv.readBytes(in);
                        this.addPrivateKey(priv);
                    }
                } else {
                    EncType etype = this._leaseSet.getEncryptionKey().getType();
                    if (etype == null) {
                        throw new I2CPMessageException("Unsupported encryption type");
                    }
                    this._privateKey = new PrivateKey(etype);
                    this._privateKey.readBytes(in);
                }
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error reading the CreateLeaseSetMessage", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._leaseSet == null) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        int type = this._leaseSet.getType();
        if (this._sessionId == null || type != 7 && this._privateKey == null) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        int size = 5 + this._leaseSet.size();
        if (type != 7) {
            for (PrivateKey pk : this.getPrivateKeys()) {
                size += pk.length();
            }
        }
        ByteArrayStream os = new ByteArrayStream(size);
        try {
            this._sessionId.writeBytes(os);
            os.write(this._leaseSet.getType());
            this._leaseSet.writeBytes(os);
            if (type != 7) {
                List<PrivateKey> pks = this.getPrivateKeys();
                os.write(pks.size());
                for (PrivateKey pk : pks) {
                    EncType etype = pk.getType();
                    DataHelper.writeLong(os, 2, etype.getCode());
                    DataHelper.writeLong(os, 2, pk.length());
                    pk.writeBytes(os);
                }
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    @Override
    public int getType() {
        return 41;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[CreateLeaseSet2Message: ");
        buf.append("\n\tLeaseSet: ").append(this._leaseSet);
        int type = this._leaseSet.getType();
        if (type != 7 && type != 5) {
            for (PrivateKey pk : this.getPrivateKeys()) {
                buf.append("\n\tPrivateKey: ").append(pk);
            }
        }
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("]");
        return buf.toString();
    }
}

