/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceConfig;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.ReinviteMethod;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.auth.AbstractAuthAuthority;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeSelector;
import org.jitsi.jicofo.bridge.ConferenceBridgeProperties;
import org.jitsi.jicofo.bridge.colibri.ColibriSessionManager;
import org.jitsi.jicofo.bridge.colibri.ColibriV2SessionManager;
import org.jitsi.jicofo.conference.ConferenceMetrics;
import org.jitsi.jicofo.conference.ConferenceUtilKt;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.conference.JitsiMeetConfig;
import org.jitsi.jicofo.conference.MuteResult;
import org.jitsi.jicofo.conference.Participant;
import org.jitsi.jicofo.conference.ParticipantInviteRunnable;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.conference.source.EndpointSourceSet;
import org.jitsi.jicofo.conference.source.ValidatingConferenceSourceMap;
import org.jitsi.jicofo.conference.source.ValidationFailedException;
import org.jitsi.jicofo.jibri.JibriDetector;
import org.jitsi.jicofo.jibri.JibriRecorder;
import org.jitsi.jicofo.jibri.JibriSipGateway;
import org.jitsi.jicofo.jigasi.JigasiConfig;
import org.jitsi.jicofo.jigasi.TranscriberManager;
import org.jitsi.jicofo.util.PreferenceAggregator;
import org.jitsi.jicofo.util.RateLimitedStat;
import org.jitsi.jicofo.version.CurrentVersionImpl;
import org.jitsi.jicofo.visitors.VisitorsConfig;
import org.jitsi.jicofo.xmpp.Features;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.IqRequest;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.VisitorsManager;
import org.jitsi.jicofo.xmpp.XmppConfig;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.XmppVisitorConnectionConfig;
import org.jitsi.jicofo.xmpp.muc.AuthenticationRoleManager;
import org.jitsi.jicofo.xmpp.muc.AutoOwnerRoleManager;
import org.jitsi.jicofo.xmpp.muc.ChatRoom;
import org.jitsi.jicofo.xmpp.muc.ChatRoomInfo;
import org.jitsi.jicofo.xmpp.muc.ChatRoomListener;
import org.jitsi.jicofo.xmpp.muc.ChatRoomMember;
import org.jitsi.jicofo.xmpp.muc.ChatRoomRoleManager;
import org.jitsi.jicofo.xmpp.muc.DefaultChatRoomListener;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.colibri2.InitialLastN;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jitsi.xmpp.extensions.jitsimeet.BridgeNotAvailablePacketExt;
import org.jitsi.xmpp.extensions.jitsimeet.ComponentVersionsExtension;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceProperties;
import org.jitsi.xmpp.extensions.jitsimeet.EtherpadPacketExt;
import org.jitsi.xmpp.extensions.jitsimeet.MuteIq;
import org.jitsi.xmpp.extensions.jitsimeet.MuteVideoIq;
import org.jitsi.xmpp.extensions.visitors.ConnectVnodePacketExtension;
import org.jitsi.xmpp.extensions.visitors.DisconnectVnodePacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.caps.packet.CapsExtension;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class JitsiMeetConferenceImpl
implements JitsiMeetConference,
XmppProvider.Listener {
    @NotNull
    private final EntityBareJid roomName;
    private final ConferenceListener listener;
    @NotNull
    private final Logger logger;
    @NotNull
    private final JitsiMeetConfig config;
    private final ChatRoomListener chatRoomListener = new ChatRoomListenerImpl();
    private volatile ChatRoom chatRoom;
    @Nullable
    private EntityBareJid mainRoomJid = null;
    private final Map<String, ChatRoom> visitorChatRooms = new ConcurrentHashMap<String, ChatRoom>();
    private final Map<Jid, Participant> participants = new ConcurrentHashMap<Jid, Participant>();
    private final Object participantLock = new Object();
    private final RateLimitedStat visitorCount = new RateLimitedStat(VisitorsConfig.config.getNotificationInterval(), numVisitors -> {
        this.setConferenceProperty("visitor-count", Integer.toString(numVisitors));
        return null;
    });
    private final PreferenceAggregator visitorCodecs;
    private JibriRecorder jibriRecorder;
    private JibriSipGateway jibriSipGateway;
    private TranscriberManager transcriberManager;
    private ChatRoomRoleManager chatRoomRoleManager;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Future<?> singleParticipantTout;
    private Future<?> conferenceStartTimeout;
    private boolean startAudioMuted = false;
    private boolean startVideoMuted = false;
    private final String etherpadName;
    private ColibriSessionManager colibriSessionManager;
    private final ColibriSessionManagerListener colibriSessionManagerListener = new ColibriSessionManagerListener();
    private final ConcurrentHashMap<String, String> conferenceProperties = new ConcurrentHashMap();
    private final boolean includeInStatistics;
    private final BridgeSelectorEventHandler bridgeSelectorEventHandler = new BridgeSelectorEventHandler();
    @NotNull
    private final JicofoServices jicofoServices;
    private final ValidatingConferenceSourceMap conferenceSources = new ValidatingConferenceSourceMap(ConferenceConfig.config.getMaxSsrcsPerUser(), ConferenceConfig.config.getMaxSsrcGroupsPerUser());
    private boolean audioLimitReached = false;
    private boolean videoLimitReached = false;
    private final String jvbVersion;
    private boolean visitorsBroadcastEnabled = VisitorsConfig.config.getAutoEnableBroadcast();
    @Nullable
    private String meetingId;
    private long userParticipantCount = 0L;

    public JitsiMeetConferenceImpl(@NotNull EntityBareJid roomName, ConferenceListener listener, @NotNull Map<String, String> properties2, Level logLevel, String jvbVersion, boolean includeInStatistics, @NotNull JicofoServices jicofoServices) {
        this.logger = new LoggerImpl(JitsiMeetConferenceImpl.class.getName(), logLevel);
        this.logger.addContext("room", roomName.toString());
        this.config = new JitsiMeetConfig(properties2);
        this.roomName = roomName;
        this.listener = listener;
        this.etherpadName = this.createSharedDocumentName();
        this.includeInStatistics = includeInStatistics;
        this.jicofoServices = jicofoServices;
        this.jvbVersion = jvbVersion;
        this.conferenceStartTimeout = TaskPools.getScheduledPool().schedule(() -> {
            if (includeInStatistics) {
                this.logger.info("Expiring due to initial timeout.");
            }
            this.stop();
        }, ConferenceConfig.config.getConferenceStartTimeout().toMillis(), TimeUnit.MILLISECONDS);
        this.visitorCodecs = new PreferenceAggregator(this.logger, codecs -> {
            this.setConferenceProperty("visitor-codecs", String.join((CharSequence)",", codecs));
            return null;
        });
        this.logger.info("Created new conference.");
    }

    @Override
    @Nullable
    public String getMeetingId() {
        return this.meetingId;
    }

    @Override
    @Nullable
    public EntityBareJid getMainRoomJid() {
        return this.mainRoomJid;
    }

    private ColibriSessionManager getColibriSessionManager() {
        if (this.colibriSessionManager == null) {
            String meetingId = Objects.requireNonNull(this.meetingId);
            this.colibriSessionManager = new ColibriV2SessionManager(this.jicofoServices.getXmppServices().getServiceConnection().getXmppConnection(), this.jicofoServices.getBridgeSelector(), this.getRoomName().toString(), meetingId, this.config.getRtcStatsEnabled(), this.jvbVersion, this.logger);
            this.colibriSessionManager.addListener(this.colibriSessionManagerListener);
        }
        return this.colibriSessionManager;
    }

    public void start() throws Exception {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        try {
            JibriDetector sipJibriDetector;
            JibriDetector jibriDetector;
            XmppProvider clientXmppProvider = this.getClientXmppProvider();
            BridgeSelector bridgeSelector = this.jicofoServices.getBridgeSelector();
            bridgeSelector.addHandler(this.bridgeSelectorEventHandler);
            if (clientXmppProvider.getRegistered()) {
                this.joinTheRoom();
            }
            if ((jibriDetector = this.jicofoServices.getJibriDetector()) != null) {
                this.jibriRecorder = new JibriRecorder(this, jibriDetector, this.logger);
            }
            if ((sipJibriDetector = this.jicofoServices.getSipJibriDetector()) != null) {
                this.jibriSipGateway = new JibriSipGateway(this, sipJibriDetector, this.logger);
            }
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception x) {
                this.logger.warn("An exception was caught while invoking stop()", x);
            }
            throw e;
        }
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.visitorCount.stop();
        if (this.jibriSipGateway != null) {
            try {
                this.jibriSipGateway.shutdown();
            }
            catch (Exception e) {
                this.logger.error("jibriSipGateway.shutdown error", e);
            }
            this.jibriSipGateway = null;
        }
        if (this.jibriRecorder != null) {
            try {
                this.jibriRecorder.shutdown();
            }
            catch (Exception e) {
                this.logger.error("jibriRecorder.shutdown error", e);
            }
            this.jibriRecorder = null;
        }
        BridgeSelector bridgeSelector = this.jicofoServices.getBridgeSelector();
        bridgeSelector.removeHandler(this.bridgeSelectorEventHandler);
        if (this.colibriSessionManager != null) {
            this.colibriSessionManager.removeListener(this.colibriSessionManagerListener);
        }
        try {
            this.expireBridgeSessions();
        }
        catch (Exception e) {
            this.logger.error("disposeConference error", e);
        }
        try {
            this.leaveTheRoom();
        }
        catch (Exception e) {
            this.logger.error("leaveTheRoom error", e);
        }
        this.logger.info("Stopped.");
        if (this.listener != null) {
            this.listener.conferenceEnded(this);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    private void joinTheRoom() throws Exception {
        ChatRoom chatRoom;
        this.logger.info("Joining " + String.valueOf(this.roomName));
        this.chatRoom = chatRoom = this.getClientXmppProvider().findOrCreateRoom(this.roomName);
        chatRoom.addListener(this.chatRoomListener);
        this.transcriberManager = new TranscriberManager(this.jicofoServices.getXmppServices().getXmppConnectionByName(JigasiConfig.config.xmppConnectionName()), this, chatRoom, this.jicofoServices.getXmppServices().getJigasiDetector(), this.logger);
        ChatRoomInfo chatRoomInfo = chatRoom.join();
        if (chatRoomInfo.getMeetingId() == null) {
            this.meetingId = UUID.randomUUID().toString();
            this.logger.warn("No meetingId set for the MUC. Generating one locally.");
        } else {
            this.meetingId = chatRoomInfo.getMeetingId();
        }
        this.logger.addContext("meeting_id", this.meetingId);
        this.mainRoomJid = chatRoomInfo.getMainRoomJid();
        AbstractAuthAuthority authenticationAuthority = this.jicofoServices.getAuthenticationAuthority();
        if (authenticationAuthority != null) {
            this.chatRoomRoleManager = new AuthenticationRoleManager(chatRoom, authenticationAuthority);
            chatRoom.addListener(this.chatRoomRoleManager);
            this.chatRoomRoleManager.grantOwnership();
        } else if (ConferenceConfig.config.enableAutoOwner() && this.mainRoomJid == null) {
            this.chatRoomRoleManager = new AutoOwnerRoleManager(chatRoom);
            chatRoom.addListener(this.chatRoomRoleManager);
            this.chatRoomRoleManager.grantOwnership();
        }
        ArrayList<AbstractPacketExtension> presenceExtensions = new ArrayList<AbstractPacketExtension>();
        presenceExtensions.add(EtherpadPacketExt.forDocumentName(this.etherpadName));
        ComponentVersionsExtension versionsExtension = new ComponentVersionsExtension();
        versionsExtension.addComponentVersion("focus", CurrentVersionImpl.VERSION.toString());
        presenceExtensions.add(versionsExtension);
        this.setConferenceProperty("support-terminate-restart", Boolean.TRUE.toString(), false);
        if (VisitorsConfig.config.getEnabled()) {
            this.setConferenceProperty("visitors-enabled", Boolean.TRUE.toString(), false);
        }
        presenceExtensions.add(this.createConferenceProperties());
        chatRoom.addPresenceExtensions(presenceExtensions);
    }

    private void setConferenceProperty(@NotNull String key, @NotNull String value2) {
        this.setConferenceProperty(key, value2, true);
    }

    private void setConferenceProperty(@NotNull String key, @NotNull String value2, boolean updatePresence) {
        String oldValue = this.conferenceProperties.put(key, value2);
        ChatRoom chatRoom = this.chatRoom;
        if (updatePresence && chatRoom != null && !value2.equals(oldValue)) {
            chatRoom.setPresenceExtension(this.createConferenceProperties());
        }
    }

    private ConferenceProperties createConferenceProperties() {
        ConferenceProperties conferenceProperties = new ConferenceProperties();
        this.conferenceProperties.forEach(conferenceProperties::put);
        return conferenceProperties;
    }

    private void onNumAudioSendersChanged(int numAudioSenders) {
        boolean newValue;
        boolean bl = newValue = numAudioSenders >= ConferenceConfig.config.getMaxAudioSenders();
        if (this.audioLimitReached != newValue) {
            this.audioLimitReached = newValue;
            this.setConferenceProperty("audio-limit-reached", String.valueOf(this.audioLimitReached));
        }
    }

    private void onNumVideoSendersChanged(int numVideoSenders) {
        boolean newValue;
        boolean bl = newValue = numVideoSenders >= ConferenceConfig.config.getMaxVideoSenders();
        if (this.videoLimitReached != newValue) {
            this.videoLimitReached = newValue;
            this.setConferenceProperty("video-limit-reached", String.valueOf(this.videoLimitReached));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveTheRoom() {
        if (this.chatRoom == null) {
            this.logger.error("Chat room already left!");
            return;
        }
        if (this.chatRoomRoleManager != null) {
            this.chatRoom.removeListener(this.chatRoomRoleManager);
            this.chatRoomRoleManager.stop();
        }
        if (this.transcriberManager != null) {
            this.transcriberManager.dispose();
            this.transcriberManager = null;
        }
        this.chatRoom.leave();
        this.chatRoom.removeListener(this.chatRoomListener);
        this.chatRoom = null;
        ArrayList disconnectVnodeExtensions = new ArrayList();
        Map<String, ChatRoom> map = this.visitorChatRooms;
        synchronized (map) {
            this.visitorChatRooms.forEach((vnode, visitorChatRoom) -> {
                disconnectVnodeExtensions.add(new DisconnectVnodePacketExtension((String)vnode));
                try {
                    visitorChatRoom.removeAllListeners();
                    visitorChatRoom.leave();
                }
                catch (Exception e) {
                    this.logger.error("Failed to leave visitor room", e);
                }
            });
            this.visitorChatRooms.clear();
        }
        if (!disconnectVnodeExtensions.isEmpty()) {
            this.jicofoServices.getXmppServices().getVisitorsManager().sendIqToComponent(this.roomName, disconnectVnodeExtensions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMemberJoined(@NotNull ChatRoomMember chatRoomMember) {
        CapsExtension caps;
        Presence presence = chatRoomMember.getPresence();
        CapsExtension capsExtension = caps = presence == null ? null : presence.getExtension(CapsExtension.class);
        if (caps != null && caps.getHash() != null && EntityCapsManager.getNodeVerHashByJid(chatRoomMember.getOccupantJid()) == null) {
            this.logger.info("Caps extension present, but JID does not exist in EntityCapsManager.");
            Thread.yield();
        }
        chatRoomMember.getFeatures();
        Object object = this.participantLock;
        synchronized (object) {
            if (this.conferenceStartTimeout != null) {
                this.conferenceStartTimeout.cancel(true);
                this.conferenceStartTimeout = null;
            }
            if (chatRoomMember.getChatRoom().getChatMember(chatRoomMember.getOccupantJid()) != chatRoomMember) {
                this.logger.warn("ChatRoomMember is no longer a member of its room. Will not invite.");
                return;
            }
            if (chatRoomMember.getRole() == MemberRole.VISITOR && !VisitorsConfig.config.getEnabled()) {
                this.logger.warn("Ignoring a visitor because visitors are not configured:" + chatRoomMember.getName());
                return;
            }
            Object room = ", room=";
            room = chatRoomMember.getChatRoom() == this.chatRoom ? (String)room + "main" : (String)room + String.valueOf(chatRoomMember.getChatRoom().getRoomJid());
            this.logger.info("Member joined:" + chatRoomMember.getName() + " stats-id=" + chatRoomMember.getStatsId() + " region=" + chatRoomMember.getRegion() + " audioMuted=" + chatRoomMember.isAudioMuted() + " videoMuted=" + chatRoomMember.isVideoMuted() + " role=" + String.valueOf((Object)chatRoomMember.getRole()) + " isJibri=" + chatRoomMember.isJibri() + " isJigasi=" + chatRoomMember.isJigasi() + " isTranscriber=" + chatRoomMember.isTranscriber() + (String)room);
            if (!this.checkMinParticipants()) {
                return;
            }
            this.cancelSingleParticipantTimeout();
            if (this.participants.size() == 0) {
                for (ChatRoomMember member : this.chatRoom.getMembers()) {
                    this.inviteChatMember(member, member == chatRoomMember);
                }
                for (ChatRoom visitorChatRoom : this.visitorChatRooms.values()) {
                    for (ChatRoomMember member : visitorChatRoom.getMembers()) {
                        if (member.getRole() != MemberRole.VISITOR) continue;
                        this.inviteChatMember(member, member == chatRoomMember);
                    }
                }
            } else {
                this.inviteChatMember(chatRoomMember, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inviteChatMember(ChatRoomMember chatRoomMember, boolean justJoined) {
        Object object = this.participantLock;
        synchronized (object) {
            boolean added;
            if (this.participants.get(chatRoomMember.getOccupantJid()) != null) {
                return;
            }
            Set<Features> features2 = chatRoomMember.getFeatures();
            this.logger.info("Creating participant " + chatRoomMember.getName() + " with features=" + String.valueOf(features2));
            Participant participant = new Participant(chatRoomMember, this, this.jicofoServices.getXmppServices().getJingleHandler(), this.logger, features2);
            ConferenceMetrics.participants.inc();
            boolean bl = added = this.participants.put(chatRoomMember.getOccupantJid(), participant) == null;
            if (added) {
                if (participant.isUserParticipant()) {
                    this.userParticipantAdded();
                } else if (participant.getChatMember().getRole() == MemberRole.VISITOR) {
                    this.visitorAdded(participant.getChatMember().getVideoCodecs());
                }
            }
            this.inviteParticipant(participant, false, justJoined);
        }
    }

    private void inviteParticipant(@NotNull Participant participant, boolean reInvite, boolean justJoined) {
        ParticipantInviteRunnable channelAllocator = new ParticipantInviteRunnable(this, this.getColibriSessionManager(), participant, this.hasToStartAudioMuted(justJoined), this.hasToStartVideoMuted(justJoined), reInvite, this.logger);
        participant.setInviteRunnable(channelAllocator);
        TaskPools.getIoPool().execute(channelAllocator);
    }

    @NotNull
    EndpointSourceSet getSourcesForParticipant(@NotNull Participant participant) {
        EndpointSourceSet s2 = this.conferenceSources.get(participant.getEndpointId());
        return s2 != null ? s2 : EndpointSourceSet.EMPTY;
    }

    private boolean hasToStartAudioMuted(boolean justJoined) {
        if (this.startAudioMuted && justJoined) {
            return true;
        }
        int limit = ConferenceConfig.config.getMaxAudioSenders();
        Integer startAudioMutedInt = this.config.getStartAudioMuted();
        if (startAudioMutedInt != null) {
            limit = Math.min(limit, startAudioMutedInt);
        }
        return this.getParticipantCount() > limit;
    }

    private boolean hasToStartVideoMuted(boolean justJoined) {
        if (this.startVideoMuted && justJoined) {
            return true;
        }
        int limit = ConferenceConfig.config.getMaxVideoSenders();
        Integer startVideoMutedInt = this.config.getStartVideoMuted();
        if (startVideoMutedInt != null) {
            limit = Math.min(limit, startVideoMutedInt);
        }
        return this.getParticipantCount() > limit;
    }

    private boolean checkMinParticipants() {
        ChatRoom chatRoom = this.getChatRoom();
        if (chatRoom == null) {
            return false;
        }
        int minParticipants = ConferenceConfig.config.getMinParticipants();
        int memberCount = chatRoom.getMemberCount() + this.visitorChatRooms.values().stream().mapToInt(ChatRoom::getMemberCount).sum();
        return memberCount >= minParticipants;
    }

    private void expireBridgeSessions() {
        this.cancelSingleParticipantTimeout();
        if (this.colibriSessionManager != null) {
            this.colibriSessionManager.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMemberKicked(ChatRoomMember chatRoomMember) {
        Object object = this.participantLock;
        synchronized (object) {
            this.logger.info("Member kicked: " + chatRoomMember.getName());
            this.onMemberLeft(chatRoomMember);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMemberLeft(ChatRoomMember chatRoomMember) {
        Object object = this.participantLock;
        synchronized (object) {
            this.logger.info("Member left:" + chatRoomMember.getName());
            Participant leftParticipant = this.participants.get(chatRoomMember.getOccupantJid());
            if (leftParticipant != null) {
                this.terminateParticipant(leftParticipant, Reason.GONE, null, false, false, false);
            } else {
                this.logger.warn("Participant not found for " + chatRoomMember.getName() + ". Terminated already or never started?");
            }
            if (this.participants.size() == 1) {
                this.rescheduleSingleParticipantTimeout();
            } else if (this.participants.size() == 0) {
                this.expireBridgeSessions();
            }
        }
        this.maybeStop();
    }

    private void maybeStop() {
        ChatRoom chatRoom = this.chatRoom;
        if (chatRoom == null || chatRoom.getMemberCount() == 0) {
            if (this.jicofoServices.getFocusManager().hasBreakoutRooms(this.roomName)) {
                this.logger.info("Breakout rooms still present, will not stop.");
            } else {
                this.logger.info("Last member left, stopping.");
                this.stop();
            }
        }
    }

    public void breakoutConferenceEnded() {
        this.maybeStop();
    }

    @Override
    public void mucConfigurationChanged() {
        ChatRoom chatRoom = this.chatRoom;
        if (chatRoom != null) {
            chatRoom.reloadConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateParticipant(Participant participant, @NotNull Reason reason, String message, boolean sendSessionTerminate, boolean sendSourceRemove, boolean willReinvite) {
        this.logger.info(String.format("Terminating %s, reason: %s, send session-terminate: %s", new Object[]{participant.getChatMember().getName(), reason, sendSessionTerminate}));
        Object object = this.participantLock;
        synchronized (object) {
            participant.terminateJingleSession(reason, message, sendSessionTerminate);
            this.removeParticipantSources(participant, sendSourceRemove, false);
            Participant removed = this.participants.remove(participant.getChatMember().getOccupantJid());
            this.logger.info("Removed participant " + participant.getChatMember().getName() + " removed=" + (removed != null));
            if (!willReinvite && removed != null) {
                if (removed.isUserParticipant()) {
                    this.userParticipantRemoved();
                } else if (removed.getChatMember().getRole() == MemberRole.VISITOR) {
                    this.visitorRemoved(removed.getChatMember().getVideoCodecs());
                }
            }
        }
        this.getColibriSessionManager().removeParticipant(participant.getEndpointId());
    }

    @Override
    public void componentsChanged(Set<XmppProvider.Component> components) {
    }

    @Override
    public void registrationChanged(boolean registered) {
        if (registered) {
            this.logger.info("XMPP reconnected");
            if (this.chatRoom == null) {
                try {
                    this.joinTheRoom();
                }
                catch (Exception e) {
                    this.logger.error("Failed to join the room: " + String.valueOf(this.roomName), e);
                    this.stop();
                }
            }
        } else {
            this.logger.info("XMPP disconnected.");
            this.stop();
        }
    }

    @Override
    @Nullable
    public Participant getParticipant(@NotNull Jid occupantJid) {
        return this.participants.get(occupantJid);
    }

    @Override
    public MemberRole getRoleForMucJid(Jid mucJid) {
        if (this.chatRoom == null) {
            return null;
        }
        for (ChatRoomMember member : this.chatRoom.getMembers()) {
            if (!member.getOccupantJid().equals(mucJid)) continue;
            return member.getRole();
        }
        return null;
    }

    public void iceFailed(@NotNull Participant participant, String bridgeSessionId) {
        String existingBridgeSessionId = this.getColibriSessionManager().getBridgeSessionId(participant.getEndpointId());
        if (Objects.equals(bridgeSessionId, existingBridgeSessionId)) {
            this.logger.info(String.format("Received ICE failed notification from %s, bridge-session ID: %s", participant.getEndpointId(), bridgeSessionId));
            this.reInviteParticipant(participant);
        } else {
            this.logger.info(String.format("Ignored ICE failed notification for invalid session, participant: %s, bridge session ID: %s", participant.getEndpointId(), bridgeSessionId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateSession(@NotNull Participant participant, String bridgeSessionId, boolean reinvite) throws InvalidBridgeSessionIdException {
        String existingBridgeSessionId = this.getColibriSessionManager().getBridgeSessionId(participant.getEndpointId());
        if (!Objects.equals(bridgeSessionId, existingBridgeSessionId)) {
            throw new InvalidBridgeSessionIdException(bridgeSessionId + " is not a currently active session");
        }
        Object object = this.participantLock;
        synchronized (object) {
            this.terminateParticipant(participant, Reason.SUCCESS, reinvite ? "reinvite requested" : null, false, true, reinvite);
            if (reinvite) {
                this.participants.put(participant.getChatMember().getOccupantJid(), participant);
                this.inviteParticipant(participant, false, false);
            }
        }
    }

    private void propagateNewSources(Participant sourceOwner, EndpointSourceSet sources) {
        if (sources.isEmpty()) {
            this.logger.debug("No new sources to propagate.");
            return;
        }
        ConferenceSourceMap conferenceSourceMap = new ConferenceSourceMap(sourceOwner.getEndpointId(), sources);
        this.participants.values().stream().filter(otherParticipant -> otherParticipant != sourceOwner).forEach(participant -> participant.addRemoteSources(conferenceSourceMap));
    }

    public void updateTransport(@NotNull Participant participant, @NotNull IceUdpTransportPacketExtension transport) {
        this.getColibriSessionManager().updateParticipant(participant.getEndpointId(), transport, null, null, false);
    }

    public void addSource(@NotNull Participant participant, @NotNull EndpointSourceSet sourcesAdvertised) throws SenderCountExceededException, ValidationFailedException {
        boolean rejectedVideoSource;
        boolean rejectedAudioSource = sourcesAdvertised.getHasAudio() && this.chatRoom.getAudioSendersCount() >= ConferenceConfig.config.getMaxAudioSenders();
        boolean bl = rejectedVideoSource = sourcesAdvertised.getHasVideo() && this.chatRoom.getVideoSendersCount() >= ConferenceConfig.config.getMaxVideoSenders();
        if (rejectedAudioSource || rejectedVideoSource) {
            throw new SenderCountExceededException("Sender count exceeded for: " + (rejectedAudioSource ? "audio " : "") + (rejectedVideoSource ? "video" : ""));
        }
        EndpointSourceSet sourcesAccepted = this.conferenceSources.tryToAdd(participant.getEndpointId(), sourcesAdvertised);
        this.logger.debug(() -> "Accepted sources from " + participant.getEndpointId() + ": " + String.valueOf(sourcesAccepted));
        if (sourcesAccepted.isEmpty()) {
            this.logger.warn("Stop processing source-add, no new sources added: " + participant.getEndpointId());
            return;
        }
        this.getColibriSessionManager().updateParticipant(participant.getEndpointId(), null, participant.getSources(), null, false);
        this.propagateNewSources(participant, sourcesAccepted);
    }

    public void removeSources(@NotNull Participant participant, @NotNull EndpointSourceSet sourcesRequestedToBeRemoved) throws ValidationFailedException {
        String participantId = participant.getEndpointId();
        EndpointSourceSet sourcesAcceptedToBeRemoved = this.conferenceSources.tryToRemove(participantId, sourcesRequestedToBeRemoved);
        this.logger.debug(() -> "Received source removal request from " + participantId + ": " + String.valueOf(sourcesRequestedToBeRemoved));
        this.logger.debug(() -> "Accepted sources to remove from " + participantId + ": " + String.valueOf(sourcesAcceptedToBeRemoved));
        if (sourcesAcceptedToBeRemoved.isEmpty()) {
            this.logger.warn("No sources or groups to be removed from " + participantId + ". The requested sources to remove: " + String.valueOf(sourcesRequestedToBeRemoved));
            return;
        }
        this.getColibriSessionManager().updateParticipant(participant.getEndpointId(), null, participant.getSources(), null, false);
        this.sendSourceRemove(new ConferenceSourceMap(participantId, sourcesAcceptedToBeRemoved), participant);
    }

    void acceptSession(@NotNull Participant participant, @NotNull EndpointSourceSet sourcesAdvertised, IceUdpTransportPacketExtension transport, @Nullable InitialLastN initialLastN) throws ValidationFailedException {
        String participantId = participant.getEndpointId();
        EndpointSourceSet sourcesAccepted = EndpointSourceSet.EMPTY;
        if (!sourcesAdvertised.isEmpty()) {
            sourcesAccepted = this.conferenceSources.tryToAdd(participantId, sourcesAdvertised);
        }
        this.getColibriSessionManager().updateParticipant(participantId, transport, this.getSourcesForParticipant(participant), initialLastN, false);
        if (!sourcesAccepted.isEmpty()) {
            this.logger.info("Accepted initial sources from " + participantId + ": " + String.valueOf(sourcesAccepted));
            this.propagateNewSources(participant, sourcesAccepted);
        } else {
            this.logger.debug("Session accepted with no sources.");
        }
        participant.sendQueuedRemoteSources();
    }

    private void removeParticipantSources(@NotNull Participant participant, boolean sendSourceRemove, boolean updateParticipant2) {
        String participantId = participant.getEndpointId();
        EndpointSourceSet sourcesRemoved = this.conferenceSources.remove(participantId);
        if (sourcesRemoved != null && !sourcesRemoved.isEmpty()) {
            if (updateParticipant2) {
                this.getColibriSessionManager().updateParticipant(participant.getEndpointId(), null, participant.getSources(), null, true);
            }
            if (sendSourceRemove) {
                this.sendSourceRemove(new ConferenceSourceMap(participantId, sourcesRemoved), participant);
            }
        }
    }

    private void sendSourceRemove(ConferenceSourceMap sources, Participant except) {
        if (sources.isEmpty()) {
            this.logger.debug("No sources to remove.");
            return;
        }
        this.participants.values().stream().filter(participant -> participant != except).forEach(participant -> participant.removeRemoteSources(sources));
    }

    @NotNull
    public ConferenceSourceMap getSources() {
        return this.conferenceSources.unmodifiable();
    }

    @Override
    @NotNull
    public EntityBareJid getRoomName() {
        return this.roomName;
    }

    @NotNull
    public XmppProvider getClientXmppProvider() {
        return this.jicofoServices.getXmppServices().getClientConnection();
    }

    public boolean hasMember(Jid jid) {
        ChatRoom chatRoom = this.chatRoom;
        return this.hasMember(jid, chatRoom) || this.visitorChatRooms.values().stream().anyMatch(c -> this.hasMember(jid, (ChatRoom)c));
    }

    private boolean hasMember(Jid jid, ChatRoom chatRoom) {
        return chatRoom != null && jid instanceof EntityFullJid && chatRoom.getChatMember((EntityFullJid)jid) != null;
    }

    @Override
    @NotNull
    public MuteResult handleMuteRequest(@NotNull Jid muterJid, @NotNull Jid toBeMutedJid, boolean doMute, @NotNull MediaType mediaType) {
        Participant muter = this.getParticipant(muterJid);
        if (muter == null) {
            this.logger.warn("Muter participant not found, jid=" + String.valueOf(muterJid));
            return MuteResult.ERROR;
        }
        if (!muterJid.equals(toBeMutedJid) && !MemberRoleKt.hasModeratorRights(muter.getChatMember().getRole())) {
            this.logger.warn("Mute not allowed for non-moderator " + String.valueOf(muterJid));
            return MuteResult.NOT_ALLOWED;
        }
        Participant participant = this.getParticipant(toBeMutedJid);
        if (participant == null) {
            this.logger.warn("Participant to be muted not found, jid=" + String.valueOf(toBeMutedJid));
            return MuteResult.ERROR;
        }
        if (!doMute) {
            if (!muterJid.equals(toBeMutedJid)) {
                this.logger.warn("Unmute not allowed, muterJid=" + String.valueOf(muterJid) + ", toBeMutedJid=" + String.valueOf(toBeMutedJid));
                return MuteResult.NOT_ALLOWED;
            }
            if (!participant.hasModeratorRights() && !this.chatRoom.isMemberAllowedToUnmute(toBeMutedJid, mediaType)) {
                this.logger.warn("Unmute not allowed due to av moderation for jid=" + String.valueOf(toBeMutedJid));
                return MuteResult.NOT_ALLOWED;
            }
        }
        if (participant.shouldSuppressForceMute()) {
            this.logger.warn("Force mute suppressed, returning NOT_ALLOWED:" + String.valueOf(participant));
            return MuteResult.NOT_ALLOWED;
        }
        this.logger.info("Will " + (doMute ? "mute" : "unmute") + " " + String.valueOf(toBeMutedJid) + " on behalf of " + String.valueOf(muterJid) + " for " + String.valueOf((Object)mediaType));
        this.getColibriSessionManager().mute(participant.getEndpointId(), doMute, mediaType);
        return MuteResult.SUCCESS;
    }

    @Override
    @NotNull
    public OrderedJsonObject getRtcstatsState() {
        return this.getDebugState(false);
    }

    @Override
    @NotNull
    public OrderedJsonObject getDebugState() {
        return this.getDebugState(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderedJsonObject getDebugState(boolean full) {
        OrderedJsonObject o = new OrderedJsonObject();
        o.put("name", this.roomName.toString());
        String meetingId = this.meetingId;
        if (meetingId != null) {
            o.put("meeting_id", meetingId);
        }
        o.put("config", this.config.getDebugState());
        ChatRoom chatRoom = this.chatRoom;
        o.put("chat_room", chatRoom == null ? "null" : chatRoom.getDebugState());
        OrderedJsonObject participantsJson = new OrderedJsonObject();
        for (Participant participant : this.participants.values()) {
            participantsJson.put(participant.getEndpointId(), participant.getDebugState(full));
        }
        o.put("participants", participantsJson);
        ChatRoomRoleManager chatRoomRoleManager = this.chatRoomRoleManager;
        o.put("chat_room_role_manager", chatRoomRoleManager == null ? "null" : chatRoomRoleManager.getDebugState());
        o.put("started", (Object)this.started.get());
        o.put("start_audio_muted", (Object)this.startAudioMuted);
        o.put("start_video_muted", (Object)this.startVideoMuted);
        if (this.colibriSessionManager != null) {
            o.put("colibri_session_manager", this.colibriSessionManager.getDebugState());
        }
        OrderedJsonObject conferencePropertiesJson = new OrderedJsonObject();
        conferencePropertiesJson.putAll((Map<? extends Object, ? extends Object>)this.conferenceProperties);
        o.put("conference_properties", conferencePropertiesJson);
        o.put("include_in_statistics", (Object)this.includeInStatistics);
        o.put("conference_sources", this.conferenceSources.toJson());
        o.put("audio_limit_reached", (Object)this.audioLimitReached);
        o.put("video_limit_reached", (Object)this.videoLimitReached);
        int visitorCount = 0;
        int participantCount = 0;
        int jibriCount = 0;
        int jigasiCount = 0;
        int transcriberCount = 0;
        Object object = this.participantLock;
        synchronized (object) {
            for (Participant p : this.participants.values()) {
                ++participantCount;
                ChatRoomMember member = p.getChatMember();
                if (member.getRole() == MemberRole.VISITOR) {
                    ++visitorCount;
                }
                if (member.isJibri()) {
                    ++jibriCount;
                }
                if (member.isTranscriber()) {
                    ++transcriberCount;
                    continue;
                }
                if (!member.isJigasi()) continue;
                ++jigasiCount;
            }
        }
        o.put("visitor_count", (Object)visitorCount);
        o.put("visitor_codecs", this.visitorCodecs.debugState());
        o.put("participant_count", (Object)participantCount);
        o.put("jibri_count", (Object)jibriCount);
        o.put("jigasi_count", (Object)jigasiCount);
        o.put("transcriber_count", (Object)transcriberCount);
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void muteAllParticipants(MediaType mediaType) {
        HashSet<Participant> participantsToMute = new HashSet<Participant>();
        Iterator iterator2 = this.participantLock;
        synchronized (iterator2) {
            for (Participant participant : this.participants.values()) {
                if (participant.shouldSuppressForceMute()) {
                    this.logger.info("Will not mute a trusted participant without unmute support (jibri, jigasi): " + String.valueOf(participant));
                    continue;
                }
                participantsToMute.add(participant);
            }
        }
        this.getColibriSessionManager().mute(participantsToMute.stream().map(Participant::getEndpointId).collect(Collectors.toSet()), true, mediaType);
        for (Participant participant : participantsToMute) {
            IQ muteStatusUpdate;
            IQ muteIq = null;
            if (mediaType == MediaType.AUDIO) {
                muteStatusUpdate = new MuteIq();
                muteStatusUpdate.setType(IQ.Type.set);
                muteStatusUpdate.setTo(participant.getMucJid());
                ((MuteIq)muteStatusUpdate).setMute(true);
                muteIq = muteStatusUpdate;
            } else if (mediaType == MediaType.VIDEO) {
                muteStatusUpdate = new MuteVideoIq();
                muteStatusUpdate.setType(IQ.Type.set);
                muteStatusUpdate.setTo(participant.getMucJid());
                ((MuteVideoIq)muteStatusUpdate).setMute(true);
                muteIq = muteStatusUpdate;
            }
            if (muteIq == null) continue;
            UtilKt.tryToSendStanza(this.getClientXmppProvider().getXmppConnection(), muteIq);
        }
    }

    @Override
    public int getParticipantCount() {
        return this.participants.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getVisitorCount() {
        Object object = this.participantLock;
        synchronized (object) {
            return this.participants.values().stream().filter(p -> p.getChatMember().getRole() == MemberRole.VISITOR).count();
        }
    }

    @Override
    public Map<Bridge, ConferenceBridgeProperties> getBridges() {
        ColibriSessionManager colibriSessionManager = this.colibriSessionManager;
        if (colibriSessionManager == null) {
            return Collections.emptyMap();
        }
        return colibriSessionManager.getBridges();
    }

    @Override
    public boolean moveEndpoint(@NotNull String endpointId, Bridge bridge2) {
        List<String> bridgeParticipants;
        if (bridge2 != null && !(bridgeParticipants = this.colibriSessionManager.getParticipants(bridge2)).contains(endpointId)) {
            this.logger.warn("Endpoint " + endpointId + " is not connected to bridge " + String.valueOf(bridge2.getJid()));
            return false;
        }
        ColibriSessionManager colibriSessionManager = this.colibriSessionManager;
        if (colibriSessionManager == null) {
            return false;
        }
        colibriSessionManager.removeParticipant(endpointId);
        return this.reInviteParticipantsById(Collections.singletonList(endpointId)) == 1;
    }

    @Override
    public int moveEndpoints(@NotNull Bridge bridge2, int numEps) {
        this.logger.info("Moving " + numEps + " endpoints from " + String.valueOf(bridge2.getJid()));
        ColibriSessionManager colibriSessionManager = this.colibriSessionManager;
        if (colibriSessionManager == null) {
            return 0;
        }
        List<String> participantIds = colibriSessionManager.getParticipants(bridge2).stream().limit(numEps).collect(Collectors.toList());
        for (String participantId : participantIds) {
            colibriSessionManager.removeParticipant(participantId);
        }
        return this.reInviteParticipantsById(participantIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String redirectVisitor(boolean visitorRequested) throws Exception {
        boolean visitorsAlreadyUsed;
        if (!VisitorsConfig.config.getEnabled()) {
            return null;
        }
        ChatRoom chatRoom = this.chatRoom;
        if (chatRoom != null && (chatRoom.getLobbyEnabled() || Boolean.FALSE.equals(chatRoom.getVisitorsEnabled()))) {
            return null;
        }
        if (VisitorsConfig.config.getRequireMucConfigFlag() && (chatRoom == null || !Boolean.TRUE.equals(chatRoom.getVisitorsEnabled()))) {
            return null;
        }
        if (this.mainRoomJid != null) {
            return null;
        }
        long participantCount = this.getUserParticipantCount();
        Map<String, ChatRoom> map = this.visitorChatRooms;
        synchronized (map) {
            visitorsAlreadyUsed = !this.visitorChatRooms.isEmpty();
        }
        int participantsSoftLimit = VisitorsConfig.config.getMaxParticipants();
        if (chatRoom != null && chatRoom.getParticipantsSoftLimit() != null && chatRoom.getParticipantsSoftLimit() > 0) {
            participantsSoftLimit = chatRoom.getParticipantsSoftLimit();
        }
        if (visitorsAlreadyUsed || visitorRequested || participantCount >= (long)participantsSoftLimit) {
            return this.selectVisitorNode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userParticipantAdded() {
        Object object = this.participantLock;
        synchronized (object) {
            ++this.userParticipantCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userParticipantRemoved() {
        Object object = this.participantLock;
        synchronized (object) {
            if (this.userParticipantCount <= 0L) {
                this.logger.error("userParticipantCount out of sync - trying to reduce when value is " + this.userParticipantCount);
            } else {
                --this.userParticipantCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUserParticipantCount() {
        Object object = this.participantLock;
        synchronized (object) {
            return this.userParticipantCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String selectVisitorNode() throws Exception {
        ChatRoom chatRoomToJoin;
        String node;
        Map<String, ChatRoom> map = this.visitorChatRooms;
        synchronized (map) {
            node = ConferenceUtilKt.selectVisitorNode(this.visitorChatRooms, this.jicofoServices.getXmppServices().getVisitorConnections());
            if (node == null) {
                this.logger.warn("Visitor node required, but none available.");
                return null;
            }
            if (this.visitorChatRooms.containsKey(node)) {
                this.visitorChatRooms.get(node).visitorInvited();
                return node;
            }
            XmppProvider xmppProvider = this.jicofoServices.getXmppServices().getXmppVisitorConnectionByName(node);
            if (xmppProvider == null) {
                this.logger.error("No XMPP provider for node " + node);
                return null;
            }
            XmppVisitorConnectionConfig config = XmppConfig.getVisitors().get(node);
            if (config == null) {
                this.logger.error("No XMPP config for node " + node);
                return null;
            }
            EntityBareJid visitorMucJid = ConferenceUtilKt.getVisitorMucJid(this.roomName, this.jicofoServices.getXmppServices().getClientConnection(), xmppProvider);
            chatRoomToJoin = xmppProvider.findOrCreateRoom(visitorMucJid);
            chatRoomToJoin.addListener(new VisitorChatRoomListenerImpl(chatRoomToJoin));
            this.visitorChatRooms.put(node, chatRoomToJoin);
            chatRoomToJoin.visitorInvited();
        }
        chatRoomToJoin.join();
        ArrayList<AbstractPacketExtension> presenceExtensions = new ArrayList<AbstractPacketExtension>();
        ComponentVersionsExtension versionsExtension = new ComponentVersionsExtension();
        versionsExtension.addComponentVersion("focus", CurrentVersionImpl.VERSION.toString());
        presenceExtensions.add(versionsExtension);
        presenceExtensions.add(this.createConferenceProperties());
        chatRoomToJoin.addPresenceExtensions(presenceExtensions);
        if (this.visitorsBroadcastEnabled) {
            VisitorsManager visitorsManager = this.jicofoServices.getXmppServices().getVisitorsManager();
            visitorsManager.sendIqToComponent(this.roomName, Collections.singletonList(new ConnectVnodePacketExtension(node)));
        } else {
            this.logger.info("Redirected visitor, broadcast not enabled yet.");
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBridgeUp(Jid bridgeJid) {
        if (!this.started.get()) {
            return;
        }
        if (this.chatRoom != null && this.checkMinParticipants() && this.getColibriSessionManager().getBridgeCount() == 0) {
            this.logger.info("New bridge available, will try to restart: " + String.valueOf(bridgeJid));
            Object object = this.participantLock;
            synchronized (object) {
                this.reInviteParticipants(this.participants.values());
            }
        }
    }

    private int reInviteParticipantsById(@NotNull List<String> participantIdsToReinvite) {
        return this.reInviteParticipantsById(participantIdsToReinvite, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reInviteParticipantsById(@NotNull List<String> participantIdsToReinvite, boolean updateParticipant2) {
        int n = participantIdsToReinvite.size();
        if (n == 0) {
            return 0;
        }
        ArrayList<Participant> participantsToReinvite = new ArrayList<Participant>();
        Object object = this.participantLock;
        synchronized (object) {
            for (Participant participant : this.participants.values()) {
                if (participantsToReinvite.size() == n) break;
                if (!participantIdsToReinvite.contains(participant.getEndpointId())) continue;
                participantsToReinvite.add(participant);
            }
            if (participantsToReinvite.size() != participantIdsToReinvite.size()) {
                this.logger.error("Can not re-invite all participants, no Participant object for some of them.");
            }
            this.reInviteParticipants(participantsToReinvite, updateParticipant2);
        }
        ConferenceMetrics.participantsMoved.addAndGet(participantsToReinvite.size());
        return participantsToReinvite.size();
    }

    public void onInviteFailed(ParticipantInviteRunnable channelAllocator) {
        this.terminateParticipant(channelAllocator.getParticipant(), Reason.GENERAL_ERROR, "jingle session failed", true, true, false);
    }

    @Override
    @Nullable
    public ChatRoom getChatRoom() {
        return this.chatRoom;
    }

    private String createSharedDocumentName() {
        if (ConferenceConfig.config.useRandomSharedDocumentName()) {
            return UUID.randomUUID().toString().replaceAll("-", "");
        }
        return this.roomName.getLocalpart().toString();
    }

    private void reInviteParticipant(Participant participant) {
        ArrayList<Participant> l = new ArrayList<Participant>(1);
        l.add(participant);
        this.reInviteParticipants(l);
    }

    private void reInviteParticipants(Collection<Participant> participants) {
        this.reInviteParticipants(participants, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reInviteParticipants(Collection<Participant> participants, boolean updateParticipant2) {
        Object object = this.participantLock;
        synchronized (object) {
            for (Participant participant : participants) {
                boolean restartJingle;
                participant.setInviteRunnable(null);
                boolean bl = restartJingle = ConferenceConfig.config.getReinviteMethod() == ReinviteMethod.RestartJingle;
                if (restartJingle) {
                    this.removeParticipantSources(participant, true, updateParticipant2);
                    participant.terminateJingleSession(Reason.SUCCESS, "moving", true);
                }
                this.inviteParticipant(participant, !restartJingle, false);
            }
        }
    }

    private void rescheduleSingleParticipantTimeout() {
        this.cancelSingleParticipantTimeout();
        long timeout = ConferenceConfig.config.getSingleParticipantTimeout().toMillis();
        this.singleParticipantTout = TaskPools.getScheduledPool().schedule(new SinglePersonTimeout(), timeout, TimeUnit.MILLISECONDS);
        this.logger.info("Scheduled single person timeout.");
    }

    private void visitorAdded(List<String> codecs) {
        this.visitorCount.adjustValue(1);
        if (codecs != null) {
            this.visitorCodecs.addPreference(codecs);
        }
    }

    private void visitorRemoved(List<String> codecs) {
        this.visitorCount.adjustValue(-1);
        if (codecs != null) {
            this.visitorCodecs.removePreference(codecs);
        }
    }

    private void cancelSingleParticipantTimeout() {
        if (this.singleParticipantTout != null) {
            this.logger.debug("Cancelling single person timeout.");
            this.singleParticipantTout.cancel(false);
            this.singleParticipantTout = null;
        }
    }

    @Override
    @NotNull
    public Set<String> getBridgeRegions() {
        return this.colibriSessionManager != null ? this.colibriSessionManager.getBridgeRegions() : Collections.emptySet();
    }

    @Override
    public boolean includeInStatistics() {
        return this.includeInStatistics;
    }

    @Override
    @NotNull
    public IqProcessingResult handleJibriRequest(@NotNull IqRequest<JibriIq> request) {
        IqProcessingResult result = new IqProcessingResult.NotProcessed();
        if (this.started.get()) {
            if (this.jibriRecorder != null) {
                result = this.jibriRecorder.handleJibriRequest(request);
            }
            if (result instanceof IqProcessingResult.NotProcessed && this.jibriSipGateway != null) {
                result = this.jibriSipGateway.handleJibriRequest(request);
            }
        }
        return result;
    }

    @Override
    public boolean acceptJigasiRequest(@NotNull Jid from) {
        return MemberRoleKt.hasModeratorRights(this.getRoleForMucJid(from));
    }

    @Override
    public JibriRecorder getJibriRecorder() {
        return this.jibriRecorder;
    }

    @Override
    public JibriSipGateway getJibriSipGateway() {
        return this.jibriSipGateway;
    }

    public String toString() {
        return String.format("JitsiMeetConferenceImpl[name=%s]", this.getRoomName());
    }

    @Override
    public boolean isRtcStatsEnabled() {
        return this.config.getRtcStatsEnabled();
    }

    static class InvalidBridgeSessionIdException
    extends Exception {
        InvalidBridgeSessionIdException(String message) {
            super(message);
        }
    }

    public static class SenderCountExceededException
    extends Exception {
        SenderCountExceededException(String message) {
            super(message);
        }
    }

    private class ColibriSessionManagerListener
    implements ColibriSessionManager.Listener {
        private ColibriSessionManagerListener() {
        }

        @Override
        public void bridgeCountChanged(int bridgeCount) {
            JitsiMeetConferenceImpl.this.setConferenceProperty("bridge-count", Integer.toString(bridgeCount));
        }

        @Override
        public void bridgeSelectionFailed() {
            ChatRoom chatRoom = JitsiMeetConferenceImpl.this.getChatRoom();
            if (chatRoom != null) {
                chatRoom.addPresenceExtensionIfMissing(new BridgeNotAvailablePacketExt());
            }
        }

        @Override
        public void bridgeSelectionSucceeded() {
            ChatRoom chatRoom = JitsiMeetConferenceImpl.this.chatRoom;
            if (chatRoom != null) {
                chatRoom.removePresenceExtensions(e -> e instanceof BridgeNotAvailablePacketExt);
            }
        }

        @Override
        public void bridgeRemoved(@NotNull Bridge bridge2, @NotNull List<String> participantIds) {
            ConferenceMetrics.bridgesRemoved.inc();
            JitsiMeetConferenceImpl.this.logger.info("Bridge " + String.valueOf(bridge2) + " was removed from the conference. Re-inviting its participants: " + String.valueOf(participantIds));
            JitsiMeetConferenceImpl.this.reInviteParticipantsById(participantIds);
        }

        @Override
        public void endpointRemoved(@NotNull String endpointId) {
            JitsiMeetConferenceImpl.this.logger.info("Endpoint " + endpointId + " was removed from the conference. Re-inviting participant.");
            JitsiMeetConferenceImpl.this.reInviteParticipantsById(Collections.singletonList(endpointId), false);
        }
    }

    private class ChatRoomListenerImpl
    implements ChatRoomListener {
        private ChatRoomListenerImpl() {
        }

        @Override
        public void roomDestroyed(String reason) {
            JitsiMeetConferenceImpl.this.logger.info("Room destroyed with reason=" + reason);
            JitsiMeetConferenceImpl.this.stop();
        }

        @Override
        public void startMutedChanged(boolean startAudioMuted, boolean startVideoMuted) {
            JitsiMeetConferenceImpl.this.startAudioMuted = startAudioMuted;
            JitsiMeetConferenceImpl.this.startVideoMuted = startVideoMuted;
        }

        @Override
        public void memberJoined(@NotNull ChatRoomMember member) {
            TaskPools.getIoPool().submit(() -> JitsiMeetConferenceImpl.this.onMemberJoined(member));
        }

        @Override
        public void memberKicked(@NotNull ChatRoomMember member) {
            JitsiMeetConferenceImpl.this.onMemberKicked(member);
        }

        @Override
        public void memberLeft(@NotNull ChatRoomMember member) {
            JitsiMeetConferenceImpl.this.onMemberLeft(member);
        }

        @Override
        public void localRoleChanged(@NotNull MemberRole newRole) {
            if (newRole != MemberRole.OWNER) {
                JitsiMeetConferenceImpl.this.logger.warn("Stopping, because the local role changed to " + String.valueOf((Object)newRole) + " (owner privileges are required).");
                JitsiMeetConferenceImpl.this.stop();
            }
        }

        @Override
        public void memberPresenceChanged(@NotNull ChatRoomMember member) {
        }

        @Override
        public void transcriptionRequestedChanged(boolean transcriptionRequested2) {
        }

        @Override
        public void numAudioSendersChanged(int numAudioSenders) {
            JitsiMeetConferenceImpl.this.onNumAudioSendersChanged(numAudioSenders);
        }

        @Override
        public void numVideoSendersChanged(int numVideoSenders) {
            JitsiMeetConferenceImpl.this.onNumVideoSendersChanged(numVideoSenders);
        }
    }

    private class VisitorChatRoomListenerImpl
    extends DefaultChatRoomListener {
        private final Logger logger;
        private final ChatRoom chatRoom;

        private VisitorChatRoomListenerImpl(ChatRoom chatRoom) {
            this.logger = JitsiMeetConferenceImpl.this.logger.createChildLogger(VisitorChatRoomListenerImpl.class.getSimpleName());
            this.chatRoom = chatRoom;
            this.logger.addContext("visitor_muc", chatRoom.getRoomJid().toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void roomDestroyed(String reason) {
            this.logger.info("Visitor room destroyed with reason=" + reason);
            ChatRoom chatRoomToLeave = null;
            String vnode = null;
            Map<String, ChatRoom> map = JitsiMeetConferenceImpl.this.visitorChatRooms;
            synchronized (map) {
                Map.Entry entry = JitsiMeetConferenceImpl.this.visitorChatRooms.entrySet().stream().filter(e -> e.getValue() == this.chatRoom).findFirst().orElse(null);
                if (entry != null) {
                    chatRoomToLeave = (ChatRoom)entry.getValue();
                    vnode = (String)entry.getKey();
                    JitsiMeetConferenceImpl.this.visitorChatRooms.remove(vnode);
                }
            }
            if (chatRoomToLeave != null) {
                ChatRoom finalChatRoom = chatRoomToLeave;
                TaskPools.getIoPool().submit(() -> {
                    try {
                        this.logger.info("Removing visitor chat room");
                        finalChatRoom.leave();
                    }
                    catch (Exception e) {
                        this.logger.warn("Error while leaving chat room.", e);
                    }
                });
                if (vnode != null) {
                    JitsiMeetConferenceImpl.this.jicofoServices.getXmppServices().getVisitorsManager().sendIqToComponent(JitsiMeetConferenceImpl.this.roomName, Collections.singletonList(new DisconnectVnodePacketExtension(vnode)));
                }
            }
        }

        @Override
        public void memberJoined(@NotNull ChatRoomMember member) {
            if (member.getRole() != MemberRole.VISITOR) {
                this.logger.debug("Ignoring non-visitor member of visitor room: " + String.valueOf(member));
                return;
            }
            TaskPools.getIoPool().submit(() -> JitsiMeetConferenceImpl.this.onMemberJoined(member));
        }

        @Override
        public void memberKicked(@NotNull ChatRoomMember member) {
            if (member.getRole() != MemberRole.VISITOR) {
                this.logger.debug("Member kicked for non-visitor member of visitor room: " + String.valueOf(member));
            }
            JitsiMeetConferenceImpl.this.onMemberKicked(member);
        }

        @Override
        public void memberLeft(@NotNull ChatRoomMember member) {
            if (member.getRole() != MemberRole.VISITOR) {
                this.logger.debug("Member left for non-visitor member of visitor room: " + String.valueOf(member));
            }
            JitsiMeetConferenceImpl.this.onMemberLeft(member);
        }
    }

    private class BridgeSelectorEventHandler
    implements BridgeSelector.EventHandler {
        private BridgeSelectorEventHandler() {
        }

        @Override
        public void bridgeIsShuttingDown(@NotNull Bridge bridge2) {
            List<String> participantIdsToReinvite;
            List<String> list = participantIdsToReinvite = JitsiMeetConferenceImpl.this.colibriSessionManager != null ? JitsiMeetConferenceImpl.this.colibriSessionManager.removeBridge(bridge2) : Collections.emptyList();
            if (!participantIdsToReinvite.isEmpty()) {
                JitsiMeetConferenceImpl.this.logger.info("Bridge " + String.valueOf(bridge2.getJid()) + " is shutting down, re-inviting " + String.valueOf(participantIdsToReinvite));
                JitsiMeetConferenceImpl.this.reInviteParticipantsById(participantIdsToReinvite);
            }
        }

        @Override
        public void bridgeRemoved(@NotNull Bridge bridge2) {
            List<String> participantIdsToReinvite;
            List<String> list = participantIdsToReinvite = JitsiMeetConferenceImpl.this.colibriSessionManager != null ? JitsiMeetConferenceImpl.this.colibriSessionManager.removeBridge(bridge2) : Collections.emptyList();
            if (!participantIdsToReinvite.isEmpty()) {
                JitsiMeetConferenceImpl.this.logger.info("Removed " + String.valueOf(bridge2.getJid()) + ", re-inviting " + String.valueOf(participantIdsToReinvite));
                JitsiMeetConferenceImpl.this.reInviteParticipantsById(participantIdsToReinvite);
            }
        }

        @Override
        public void bridgeAdded(Bridge bridge2) {
            JitsiMeetConferenceImpl.this.onBridgeUp(bridge2.getJid());
        }
    }

    private class SinglePersonTimeout
    implements Runnable {
        private SinglePersonTimeout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = JitsiMeetConferenceImpl.this.participantLock;
            synchronized (object) {
                if (JitsiMeetConferenceImpl.this.participants.size() == 1) {
                    Participant p = JitsiMeetConferenceImpl.this.participants.values().stream().findFirst().orElse(null);
                    JitsiMeetConferenceImpl.this.logger.info("Timing out single participant: " + p.getChatMember().getName());
                    JitsiMeetConferenceImpl.this.terminateParticipant(p, Reason.EXPIRED, "Idle session timeout", true, false, false);
                    JitsiMeetConferenceImpl.this.expireBridgeSessions();
                } else {
                    JitsiMeetConferenceImpl.this.logger.error("Should never execute if more than 1 participant?");
                }
                JitsiMeetConferenceImpl.this.singleParticipantTout = null;
            }
        }
    }

    public static interface ConferenceListener {
        public void conferenceEnded(JitsiMeetConferenceImpl var1);
    }
}

