/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.status;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.xsite.status.OfflineSiteStatus;
import org.infinispan.xsite.status.OnlineSiteStatus;
import org.infinispan.xsite.status.SiteStatus;

public abstract class AbstractSiteStatusBuilder<E> {
    private final List<E> onlineElements;
    private final List<E> offlineElements = new LinkedList();

    protected AbstractSiteStatusBuilder() {
        this.onlineElements = new LinkedList();
    }

    public final void onlineOn(E member) {
        this.onlineElements.add(member);
    }

    public final void offlineOn(E member) {
        this.offlineElements.add(member);
    }

    public final SiteStatus build() {
        if (this.isOnline()) {
            return OnlineSiteStatus.getInstance();
        }
        if (this.isOffline()) {
            return OfflineSiteStatus.getInstance();
        }
        return this.createMixedStatus(this.onlineElements, this.offlineElements);
    }

    protected boolean isOnline() {
        return !this.onlineElements.isEmpty() && this.offlineElements.isEmpty();
    }

    protected boolean isOffline() {
        return this.onlineElements.isEmpty() && !this.offlineElements.isEmpty();
    }

    protected abstract SiteStatus createMixedStatus(List<E> var1, List<E> var2);
}

