/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.AuthorizationEndpoint;
import org.keycloak.protocol.oidc.endpoints.LoginStatusIframeEndpoint;
import org.keycloak.protocol.oidc.endpoints.LogoutEndpoint;
import org.keycloak.protocol.oidc.endpoints.ThirdPartyCookiesIframeEndpoint;
import org.keycloak.protocol.oidc.endpoints.TokenEndpoint;
import org.keycloak.protocol.oidc.endpoints.TokenRevocationEndpoint;
import org.keycloak.protocol.oidc.endpoints.UserInfoEndpoint;
import org.keycloak.protocol.oidc.ext.OIDCExtProvider;
import org.keycloak.protocol.oidc.utils.JWKSServerUtils;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.CacheControlUtil;

public class OIDCLoginProtocolService {
    private final RealmModel realm;
    private final TokenManager tokenManager;
    private final EventBuilder event;
    private final KeycloakSession session;
    private final HttpHeaders headers;
    private final HttpRequest request;
    private final ClientConnection clientConnection;

    public OIDCLoginProtocolService(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.realm = session.getContext().getRealm();
        this.tokenManager = new TokenManager();
        this.event = event;
        this.request = session.getContext().getHttpRequest();
        this.headers = session.getContext().getRequestHeaders();
    }

    public static UriBuilder tokenServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
    }

    public static UriBuilder tokenServiceBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path("{realm}/protocol/openid-connect");
    }

    public static UriBuilder authUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.authUrl(baseUriBuilder);
    }

    public static UriBuilder authUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "auth");
    }

    public static UriBuilder registrationsUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "registrations");
    }

    public static UriBuilder tokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "token");
    }

    public static UriBuilder certsUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "certs");
    }

    public static UriBuilder userInfoUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "issueUserInfo");
    }

    public static UriBuilder tokenIntrospectionUrl(UriBuilder baseUriBuilder) {
        return OIDCLoginProtocolService.tokenUrl(baseUriBuilder).path(TokenEndpoint.class, "introspect");
    }

    public static UriBuilder logoutUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return OIDCLoginProtocolService.logoutUrl(baseUriBuilder);
    }

    public static UriBuilder logoutUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "logout");
    }

    public static UriBuilder tokenRevocationUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = OIDCLoginProtocolService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(OIDCLoginProtocolService.class, "revoke");
    }

    @Path(value="auth")
    public Object auth() {
        return new AuthorizationEndpoint(this.session, this.event);
    }

    @Path(value="registrations")
    public Object registrations(@QueryParam(value="token") String tokenString) {
        AuthorizationEndpoint endpoint = new AuthorizationEndpoint(this.session, this.event);
        return endpoint.register(tokenString);
    }

    @Path(value="forgot-credentials")
    public Object forgotCredentialsPage() {
        AuthorizationEndpoint endpoint = new AuthorizationEndpoint(this.session, this.event);
        return endpoint.forgotCredentials();
    }

    @Path(value="token")
    public Object token() {
        return new TokenEndpoint(this.session, this.tokenManager, this.event);
    }

    @Path(value="login-status-iframe.html")
    public Object getLoginStatusIframe() {
        return new LoginStatusIframeEndpoint(this.session);
    }

    @Path(value="3p-cookies")
    public Object thirdPartyCookiesCheck() {
        return new ThirdPartyCookiesIframeEndpoint(this.session);
    }

    @OPTIONS
    @Path(value="certs")
    @Produces(value={"application/json"})
    public Response getVersionPreflight() {
        return Cors.builder().allowedMethods(new String[]{"GET"}).preflight().auth().add(Response.ok());
    }

    @HEAD
    @Path(value="/certs")
    @Produces(value={"application/json", "application/jwk-set+json"})
    @NoCache
    public Response certsHead() {
        return this.certs();
    }

    @GET
    @Path(value="certs")
    @Produces(value={"application/json", "application/jwk-set+json"})
    @NoCache
    public Response certs() {
        this.checkSsl();
        JSONWebKeySet keySet = JWKSServerUtils.getRealmJwks(this.session, this.realm);
        Response.ResponseBuilder responseBuilder = Response.ok((Object)keySet).cacheControl(CacheControlUtil.getDefaultCacheControl());
        boolean isJwksRequest = "application/jwk-set+json".equals(this.headers.getHeaderString("Accept"));
        if (isJwksRequest) {
            responseBuilder.header("Content-Type", (Object)"application/jwk-set+json");
        } else {
            responseBuilder.header("Content-Type", (Object)"application/json");
        }
        return Cors.builder().allowAllOrigins().auth().add(responseBuilder);
    }

    @Path(value="userinfo")
    public Object issueUserInfo() {
        return new UserInfoEndpoint(this.session, this.tokenManager);
    }

    @Path(value="logout")
    public Object logout() {
        return new LogoutEndpoint(this.session, this.tokenManager, this.event);
    }

    @Path(value="revoke")
    public Object revoke() {
        return new TokenRevocationEndpoint(this.session, this.event);
    }

    @Path(value="oauth/oob")
    @GET
    public Response installedAppUrnCallback(@QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription) {
        LoginFormsProvider forms = (LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class);
        if (code != null) {
            return forms.setClientSessionCode(code).createCode();
        }
        return forms.setError(error, new Object[0]).createCode();
    }

    @Path(value="ext/{extension}")
    public Object resolveExtension(@PathParam(value="extension") String extension) {
        OIDCExtProvider provider = (OIDCExtProvider)this.session.getProvider(OIDCExtProvider.class, extension);
        if (provider != null) {
            provider.setEvent(this.event);
            return provider;
        }
        throw new NotFoundException();
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            Cors cors = Cors.builder().auth().allowedMethods(new String[]{this.request.getHttpMethod()}).auth().exposedHeaders(new String[]{"Access-Control-Allow-Methods"});
            throw new CorsErrorResponseException(cors.allowAllOrigins(), "invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }
}

