/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.Any;
import io.grpc.InternalLogId;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.client.EnvoyProtoData;
import io.grpc.xds.client.MessagePrettyPrinter;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsLogger;
import io.grpc.xds.client.XdsResourceType;
import io.grpc.xds.client.XdsTransportFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ControlPlaneClient {
    private final SynchronizationContext syncContext;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final Bootstrapper.ServerInfo serverInfo;
    private final XdsTransportFactory.XdsTransport xdsTransport;
    private final XdsClient.XdsResponseHandler xdsResponseHandler;
    private final XdsClient.ResourceStore resourceStore;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Stopwatch stopwatch;
    private final EnvoyProtoData.Node bootstrapNode;
    private final Map<XdsResourceType<?>, String> versions = new HashMap();
    private boolean shutdown;
    private boolean inError;
    @Nullable
    private AdsStream adsStream;
    @Nullable
    private BackoffPolicy retryBackoffPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle rpcRetryTimer;
    private final MessagePrettyPrinter messagePrinter;

    ControlPlaneClient(XdsTransportFactory.XdsTransport xdsTransport, Bootstrapper.ServerInfo serverInfo, EnvoyProtoData.Node bootstrapNode, XdsClient.XdsResponseHandler xdsResponseHandler, XdsClient.ResourceStore resourceStore, ScheduledExecutorService timeService, SynchronizationContext syncContext, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, MessagePrettyPrinter messagePrinter) {
        this.serverInfo = (Bootstrapper.ServerInfo)Preconditions.checkNotNull((Object)serverInfo, (Object)"serverInfo");
        this.xdsTransport = (XdsTransportFactory.XdsTransport)Preconditions.checkNotNull((Object)xdsTransport, (Object)"xdsTransport");
        this.xdsResponseHandler = (XdsClient.XdsResponseHandler)Preconditions.checkNotNull((Object)xdsResponseHandler, (Object)"xdsResponseHandler");
        this.resourceStore = (XdsClient.ResourceStore)Preconditions.checkNotNull((Object)resourceStore, (Object)"resourcesSubscriber");
        this.bootstrapNode = (EnvoyProtoData.Node)Preconditions.checkNotNull((Object)bootstrapNode, (Object)"bootstrapNode");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timeService, (Object)"timeService");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.messagePrinter = (MessagePrettyPrinter)Preconditions.checkNotNull((Object)messagePrinter, (Object)"messagePrinter");
        this.stopwatch = (Stopwatch)((Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier")).get();
        this.logId = InternalLogId.allocate((String)"xds-client", (String)serverInfo.target());
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    void shutdown() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ControlPlaneClient.this.shutdown = true;
                ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutting down");
                if (ControlPlaneClient.this.adsStream != null) {
                    ControlPlaneClient.this.adsStream.close((Exception)Status.CANCELLED.withDescription("shutdown").asException());
                }
                if (ControlPlaneClient.this.rpcRetryTimer != null && ControlPlaneClient.this.rpcRetryTimer.isPending()) {
                    ControlPlaneClient.this.rpcRetryTimer.cancel();
                }
                ControlPlaneClient.this.xdsTransport.shutdown();
            }
        });
    }

    public String toString() {
        return this.logId.toString();
    }

    public Bootstrapper.ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    void adjustResourceSubscription(XdsResourceType<?> resourceType) {
        if (this.rpcRetryTimer != null && this.rpcRetryTimer.isPending()) {
            return;
        }
        if (this.adsStream == null) {
            this.startRpcStream();
            return;
        }
        if (!this.isConnected()) {
            return;
        }
        Collection<String> resources = this.resourceStore.getSubscribedResources(this.serverInfo, resourceType);
        if (resources == null) {
            resources = Collections.emptyList();
        }
        this.adsStream.sendDiscoveryRequest(resourceType, resources);
        this.resourceStore.startMissingResourceTimers(resources, resourceType);
        if (resources.isEmpty()) {
            this.versions.remove(resourceType);
        }
    }

    void ackResponse(XdsResourceType<?> type, String versionInfo, String nonce) {
        this.versions.put(type, versionInfo);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending ACK for {0} update, nonce: {1}, current version: {2}", type.typeName(), nonce, versionInfo);
        Collection<String> resources = this.resourceStore.getSubscribedResources(this.serverInfo, type);
        if (resources == null) {
            resources = Collections.emptyList();
        }
        this.adsStream.sendDiscoveryRequest(type, versionInfo, resources, nonce, null);
    }

    void nackResponse(XdsResourceType<?> type, String nonce, String errorDetail) {
        String versionInfo = this.versions.getOrDefault(type, "");
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending NACK for {0} update, nonce: {1}, current version: {2}", type.typeName(), nonce, versionInfo);
        Collection<String> resources = this.resourceStore.getSubscribedResources(this.serverInfo, type);
        if (resources == null) {
            resources = Collections.emptyList();
        }
        this.adsStream.sendDiscoveryRequest(type, versionInfo, resources, nonce, errorDetail);
    }

    boolean isReady() {
        return this.adsStream != null && this.adsStream.call != null && this.adsStream.call.isReady() && !this.adsStream.closed;
    }

    boolean isConnected() {
        return this.adsStream != null && this.adsStream.sentInitialRequest;
    }

    boolean isInError() {
        return this.inError;
    }

    void readyHandler(boolean shouldSendInitialRequest) {
        if (shouldSendInitialRequest) {
            this.sendDiscoveryRequests();
        }
    }

    private void startRpcStream() {
        Preconditions.checkState((this.adsStream == null ? 1 : 0) != 0, (Object)"Previous adsStream has not been cleared yet");
        if (this.rpcRetryTimer != null) {
            this.rpcRetryTimer.cancel();
            this.rpcRetryTimer = null;
        }
        this.adsStream = new AdsStream();
        this.adsStream.start();
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "ADS stream started");
        this.stopwatch.reset().start();
    }

    void sendDiscoveryRequests() {
        if (this.rpcRetryTimer != null && this.rpcRetryTimer.isPending()) {
            return;
        }
        if (this.adsStream == null) {
            this.startRpcStream();
            return;
        }
        if (this.isConnected()) {
            HashSet subscribedResourceTypes = new HashSet(this.resourceStore.getSubscribedResourceTypesWithTypeUrl().values());
            for (XdsResourceType xdsResourceType : subscribedResourceTypes) {
                this.adjustResourceSubscription(xdsResourceType);
            }
        }
    }

    @Nullable
    @VisibleForTesting
    XdsResourceType<?> fromTypeUrl(String typeUrl) {
        return this.resourceStore.getSubscribedResourceTypesWithTypeUrl().get(typeUrl);
    }

    @VisibleForTesting
    static class FailingXdsTransport
    implements XdsTransportFactory.XdsTransport {
        Status error;

        public FailingXdsTransport(Status error) {
            this.error = error;
        }

        @Override
        public <ReqT, RespT> XdsTransportFactory.StreamingCall<ReqT, RespT> createStreamingCall(String fullMethodName, MethodDescriptor.Marshaller<ReqT> reqMarshaller, MethodDescriptor.Marshaller<RespT> respMarshaller) {
            return new FailingXdsStreamingCall();
        }

        @Override
        public void shutdown() {
        }

        private class FailingXdsStreamingCall<ReqT, RespT>
        implements XdsTransportFactory.StreamingCall<ReqT, RespT> {
            private FailingXdsStreamingCall() {
            }

            @Override
            public void start(XdsTransportFactory.EventHandler<RespT> eventHandler) {
                eventHandler.onStatusReceived(FailingXdsTransport.this.error);
            }

            @Override
            public void sendMessage(ReqT message) {
            }

            @Override
            public void startRecvMessage() {
            }

            @Override
            public void sendError(Exception e) {
            }

            @Override
            public boolean isReady() {
                return false;
            }
        }
    }

    private class AdsStream
    implements XdsTransportFactory.EventHandler<DiscoveryResponse> {
        private boolean responseReceived;
        private boolean sentInitialRequest;
        private boolean closed;
        private final Map<String, String> respNonces = new HashMap<String, String>();
        private final XdsTransportFactory.StreamingCall<DiscoveryRequest, DiscoveryResponse> call;
        private final MethodDescriptor<DiscoveryRequest, DiscoveryResponse> methodDescriptor = AggregatedDiscoveryServiceGrpc.getStreamAggregatedResourcesMethod();

        private AdsStream() {
            this.call = ControlPlaneClient.this.xdsTransport.createStreamingCall(this.methodDescriptor.getFullMethodName(), this.methodDescriptor.getRequestMarshaller(), this.methodDescriptor.getResponseMarshaller());
        }

        void start() {
            this.call.start(this);
        }

        void sendDiscoveryRequest(XdsResourceType<?> type, String versionInfo, Collection<String> resources, String nonce, @Nullable String errorDetail) {
            DiscoveryRequest.Builder builder = DiscoveryRequest.newBuilder().setVersionInfo(versionInfo).setNode(ControlPlaneClient.this.bootstrapNode.toEnvoyProtoNode()).addAllResourceNames(resources).setTypeUrl(type.typeUrl()).setResponseNonce(nonce);
            if (errorDetail != null) {
                com.google.rpc.Status error = com.google.rpc.Status.newBuilder().setCode(3).setMessage(errorDetail).build();
                builder.setErrorDetail(error);
            }
            DiscoveryRequest request = builder.build();
            this.call.sendMessage(request);
            if (ControlPlaneClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent DiscoveryRequest\n{0}", ControlPlaneClient.this.messagePrinter.print(request));
            }
        }

        final void sendDiscoveryRequest(XdsResourceType<?> type, Collection<String> resources) {
            ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending {0} request for resources: {1}", type, resources);
            this.sendDiscoveryRequest(type, ControlPlaneClient.this.versions.getOrDefault(type, ""), resources, this.respNonces.getOrDefault(type.typeUrl(), ""), null);
        }

        @Override
        public void onReady() {
            ControlPlaneClient.this.syncContext.execute(() -> {
                if (!ControlPlaneClient.this.isReady()) {
                    ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "ADS stream ready handler called, but not ready {0}", ControlPlaneClient.this.logId);
                    return;
                }
                ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "ADS stream ready {0}", ControlPlaneClient.this.logId);
                boolean hadSentInitialRequest = this.sentInitialRequest;
                this.sentInitialRequest = true;
                ControlPlaneClient.this.readyHandler(!hadSentInitialRequest);
            });
        }

        @Override
        public void onRecvMessage(final DiscoveryResponse response) {
            ControlPlaneClient.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    if (AdsStream.this.closed) {
                        return;
                    }
                    boolean isFirstResponse = !AdsStream.this.responseReceived;
                    AdsStream.this.responseReceived = true;
                    ControlPlaneClient.this.inError = false;
                    AdsStream.this.respNonces.put(response.getTypeUrl(), response.getNonce());
                    XdsResourceType<?> type = ControlPlaneClient.this.fromTypeUrl(response.getTypeUrl());
                    if (ControlPlaneClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                        ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received {0} response:\n{1}", type, ControlPlaneClient.this.messagePrinter.print(response));
                    }
                    if (type == null) {
                        ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Ignore an unknown type of DiscoveryResponse: {0}", response.getTypeUrl());
                        AdsStream.this.call.startRecvMessage();
                        return;
                    }
                    AdsStream.this.handleRpcResponse(type, response.getVersionInfo(), response.getResourcesList(), response.getNonce(), isFirstResponse);
                }
            });
        }

        @Override
        public void onStatusReceived(Status status) {
            ControlPlaneClient.this.syncContext.execute(() -> this.handleRpcStreamClosed(status));
        }

        final void handleRpcResponse(XdsResourceType<?> type, String versionInfo, List<Any> resources, String nonce, boolean isFirstResponse) {
            Preconditions.checkNotNull(type, (Object)"type");
            XdsClient.ProcessingTracker processingTracker = new XdsClient.ProcessingTracker(() -> this.call.startRecvMessage(), (Executor)ControlPlaneClient.this.syncContext);
            ControlPlaneClient.this.xdsResponseHandler.handleResourceResponse(type, ControlPlaneClient.this.serverInfo, versionInfo, resources, nonce, isFirstResponse, processingTracker);
            processingTracker.onComplete();
        }

        private void handleRpcStreamClosed(Status status) {
            if (this.closed) {
                return;
            }
            if (this.responseReceived || ControlPlaneClient.this.retryBackoffPolicy == null) {
                ControlPlaneClient.this.retryBackoffPolicy = ControlPlaneClient.this.backoffPolicyProvider.get();
                ControlPlaneClient.this.stopwatch.reset();
            }
            Status newStatus = status;
            if (this.responseReceived) {
                if (!status.isOk()) {
                    newStatus = Status.OK;
                    ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "ADS stream closed with error {0}: {1}. However, a response was received, so this will not be treated as an error. Cause: {2}", status.getCode(), status.getDescription(), status.getCause());
                } else {
                    ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "ADS stream closed by server after a response was received");
                }
            } else {
                ControlPlaneClient.this.inError = true;
                if (status.isOk()) {
                    newStatus = Status.UNAVAILABLE.withDescription("ADS stream closed with OK before receiving a response");
                }
                ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "ADS stream failed with status {0}: {1}. Cause: {2}", newStatus.getCode(), newStatus.getDescription(), newStatus.getCause());
            }
            this.close((Exception)newStatus.asException());
            long elapsed = ControlPlaneClient.this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            long delayNanos = Math.max(0L, ControlPlaneClient.this.retryBackoffPolicy.nextBackoffNanos() - elapsed);
            ControlPlaneClient.this.rpcRetryTimer = ControlPlaneClient.this.syncContext.schedule((Runnable)new RpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, ControlPlaneClient.this.timeService);
            ControlPlaneClient.this.xdsResponseHandler.handleStreamClosed(newStatus, !this.responseReceived);
        }

        private void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.call.sendError(error);
        }

        private void cleanUp() {
            if (ControlPlaneClient.this.adsStream == this) {
                ControlPlaneClient.this.adsStream = null;
            }
        }
    }

    @VisibleForTesting
    public final class RpcRetryTask
    implements Runnable {
        @Override
        public void run() {
            ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Retry timeout. Restart ADS stream {0}", ControlPlaneClient.this.logId);
            if (ControlPlaneClient.this.shutdown) {
                return;
            }
            ControlPlaneClient.this.startRpcStream();
        }
    }
}

