/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.addressbook;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.addressbook.AddressBook;
import net.i2p.addressbook.ConfigParser;
import net.i2p.addressbook.HostTxtIterator;
import net.i2p.addressbook.Log;
import net.i2p.addressbook.SubscriptionIterator;
import net.i2p.addressbook.SubscriptionList;
import net.i2p.app.ClientAppManager;
import net.i2p.client.naming.HostTxtEntry;
import net.i2p.client.naming.NamingService;
import net.i2p.client.naming.SingleFileNamingService;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;

class Daemon {
    public static final String VERSION = "2.0.4";
    private volatile boolean _running;
    private static final boolean DEBUG = false;
    private static final String DEFAULT_SUB = "http://i2p-projekt.i2p/hosts.txt";
    static final String OLD_DEFAULT_SUB = "http://www.i2p2.i2p/hosts.txt";
    private static final String RCVD_PROP_PREFIX = "=";
    private static final boolean MUST_VALIDATE = false;

    Daemon() {
    }

    public static void update(AddressBook local, AddressBook router, File published, SubscriptionList subscriptions, Log log) {
        for (AddressBook book : subscriptions) {
            router.merge(book, false, log);
        }
        router.write();
        if (published != null) {
            if (local != null) {
                router.merge(local, true, null);
            }
            router.write(published);
        }
        subscriptions.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(NamingService router, File published, SubscriptionList subscriptions, Log log) {
        Set<String> knownNames;
        boolean isTextFile;
        String nsClass = router.getClass().getSimpleName();
        boolean bl = isTextFile = nsClass.equals("HostsTxtNamingService") || nsClass.equals("SingleFileNamingService");
        if (isTextFile) {
            Properties opts = new Properties();
            opts.setProperty("file", "hosts.txt");
            knownNames = router.getNames(opts);
        } else {
            knownNames = null;
        }
        SingleFileNamingService publishedNS = published != null ? new SingleFileNamingService(I2PAppContext.getGlobalContext(), published.getAbsolutePath()) : null;
        SubscriptionIterator iter = subscriptions.iterator();
        while (iter.hasNext()) {
            long start = System.currentTimeMillis();
            AddressBook addressbook = (AddressBook)iter.next();
            Iterator<Map.Entry<String, HostTxtEntry>> iter2 = addressbook.iterator();
            try {
                Daemon.update(router, knownNames, publishedNS, addressbook, iter2, log);
            }
            finally {
                if (iter2 instanceof HostTxtIterator) {
                    ((HostTxtIterator)iter2).close();
                }
                addressbook.delete();
            }
        }
        subscriptions.write();
    }

    private static void update(NamingService router, Set<String> knownNames, NamingService publishedNS, AddressBook addressbook, Iterator<Map.Entry<String, HostTxtEntry>> iter, Log log) {
        ClientAppManager cmgr;
        long start = 0L;
        int old = 0;
        int nnew = 0;
        int invalid = 0;
        boolean conflict = false;
        int total = 0;
        int deleted = 0;
        while (iter.hasNext()) {
            boolean isKnown;
            Destination oldDest;
            Map.Entry<String, HostTxtEntry> entry = iter.next();
            ++total;
            String key = entry.getKey();
            if (knownNames != null) {
                oldDest = null;
                isKnown = key != null ? knownNames.contains(key) : false;
            } else {
                oldDest = key != null ? router.lookup(key) : null;
                isKnown = oldDest != null;
            }
            try {
                block87: {
                    String action;
                    OrderedProperties hprops;
                    block88: {
                        boolean allowExistingKeyInPublished;
                        OrderedProperties props;
                        Destination dest;
                        block89: {
                            block103: {
                                block104: {
                                    List<Destination> pod;
                                    HostTxtEntry he;
                                    block105: {
                                        boolean success;
                                        String poldname;
                                        block99: {
                                            block100: {
                                                List<Destination> pod2;
                                                String polddest;
                                                block102: {
                                                    block101: {
                                                        block95: {
                                                            block96: {
                                                                List<Destination> pod22;
                                                                block98: {
                                                                    Destination pod3;
                                                                    block97: {
                                                                        block93: {
                                                                            block94: {
                                                                                block90: {
                                                                                    block91: {
                                                                                        List<Destination> pod23;
                                                                                        block92: {
                                                                                            he = entry.getValue();
                                                                                            hprops = he.getProps();
                                                                                            boolean mustValidate = hprops != null;
                                                                                            String string = action = hprops != null ? hprops.getProperty("action") : null;
                                                                                            if (key == null && !he.hasValidRemoveSig()) {
                                                                                                if (log != null) {
                                                                                                    log.append("Bad signature of action " + action + " for key " + hprops.getProperty("name") + ". From: " + addressbook.getLocation());
                                                                                                }
                                                                                                ++invalid;
                                                                                                continue;
                                                                                            }
                                                                                            if (key != null && mustValidate && !he.hasValidSig()) {
                                                                                                if (log != null) {
                                                                                                    log.append("Bad signature of action " + action + " for key " + key + ". From: " + addressbook.getLocation());
                                                                                                }
                                                                                                ++invalid;
                                                                                                continue;
                                                                                            }
                                                                                            if (action == null && isKnown) break block87;
                                                                                            if (key == null || !AddressBook.isValidKey(key)) break block88;
                                                                                            dest = new Destination(he.getDest());
                                                                                            props = new OrderedProperties();
                                                                                            props.setProperty("s", addressbook.getLocation());
                                                                                            allowExistingKeyInPublished = false;
                                                                                            if (mustValidate) {
                                                                                                props.setProperty("v", "true");
                                                                                            }
                                                                                            if (hprops != null) {
                                                                                                for (Map.Entry<Object, Object> e : ((Properties)hprops).entrySet()) {
                                                                                                    props.setProperty(RCVD_PROP_PREFIX + e.getKey(), (String)e.getValue());
                                                                                                }
                                                                                            }
                                                                                            if (action == null) break block89;
                                                                                            if (!action.equals("adddest")) break block90;
                                                                                            polddest = hprops.getProperty("olddest");
                                                                                            if (polddest == null) break block91;
                                                                                            pod = new Destination(polddest);
                                                                                            pod23 = router.lookupAll(key);
                                                                                            if (pod23 != null) break block92;
                                                                                            if (!he.hasValidInnerSig()) {
                                                                                                Daemon.logInner(log, action, key, addressbook);
                                                                                                ++invalid;
                                                                                                continue;
                                                                                            }
                                                                                            break block89;
                                                                                        }
                                                                                        if (pod23.contains(dest)) {
                                                                                            ++old;
                                                                                            continue;
                                                                                        }
                                                                                        if (pod23.contains(pod)) {
                                                                                            if (!he.hasValidInnerSig()) {
                                                                                                Daemon.logInner(log, action, key, addressbook);
                                                                                                ++invalid;
                                                                                                continue;
                                                                                            }
                                                                                            boolean success2 = router.addDestination(key, dest, props);
                                                                                            if (log != null) {
                                                                                                if (success2) {
                                                                                                    log.append("Additional address for " + key + " added to address book. From: " + addressbook.getLocation());
                                                                                                } else {
                                                                                                    log.append("Failed to add additional address for " + key + " From: " + addressbook.getLocation());
                                                                                                }
                                                                                            }
                                                                                            if (publishedNS != null) {
                                                                                                success2 = publishedNS.addDestination(key, dest, props);
                                                                                                if (log != null && !success2) {
                                                                                                    log.append("Add to published address book " + publishedNS.getName() + " failed for " + key);
                                                                                                }
                                                                                            }
                                                                                            ++nnew;
                                                                                            continue;
                                                                                        }
                                                                                        Daemon.logMismatch(log, action, key, pod23, he.getDest(), addressbook);
                                                                                        ++invalid;
                                                                                        continue;
                                                                                    }
                                                                                    Daemon.logMissing(log, action, key, addressbook);
                                                                                    ++invalid;
                                                                                    continue;
                                                                                }
                                                                                if (!action.equals("addname")) break block93;
                                                                                if (isKnown) {
                                                                                    ++old;
                                                                                    continue;
                                                                                }
                                                                                poldname = hprops.getProperty("oldname");
                                                                                if (poldname == null) break block94;
                                                                                pod = router.lookupAll(poldname);
                                                                                if (pod != null && !pod.contains(dest)) {
                                                                                    Daemon.logMismatch(log, action, key, pod, he.getDest(), addressbook);
                                                                                    ++invalid;
                                                                                    continue;
                                                                                }
                                                                                break block89;
                                                                            }
                                                                            Daemon.logMissing(log, action, key, addressbook);
                                                                            ++invalid;
                                                                            continue;
                                                                        }
                                                                        if (!action.equals("addsubdomain")) break block95;
                                                                        if (isKnown) {
                                                                            ++old;
                                                                            continue;
                                                                        }
                                                                        polddest = hprops.getProperty("olddest");
                                                                        String poldname2 = hprops.getProperty("oldname");
                                                                        if (polddest == null || poldname2 == null) break block96;
                                                                        if (!AddressBook.isValidKey(poldname2) || key.indexOf('.' + poldname2) <= 0) {
                                                                            if (log != null) {
                                                                                log.append("Action: " + action + " failed because old name " + poldname2 + " is invalid. From: " + addressbook.getLocation());
                                                                            }
                                                                            ++invalid;
                                                                            continue;
                                                                        }
                                                                        pod3 = new Destination(polddest);
                                                                        pod22 = router.lookupAll(poldname2);
                                                                        if (pod22 != null) break block97;
                                                                        if (!he.hasValidInnerSig()) {
                                                                            Daemon.logInner(log, action, key, addressbook);
                                                                            ++invalid;
                                                                            continue;
                                                                        }
                                                                        break block89;
                                                                    }
                                                                    if (!pod22.contains(pod3)) break block98;
                                                                    if (!he.hasValidInnerSig()) {
                                                                        Daemon.logInner(log, action, key, addressbook);
                                                                        ++invalid;
                                                                        continue;
                                                                    }
                                                                    break block89;
                                                                }
                                                                Daemon.logMismatch(log, action, key, pod22, polddest, addressbook);
                                                                ++invalid;
                                                                continue;
                                                            }
                                                            Daemon.logMissing(log, action, key, addressbook);
                                                            ++invalid;
                                                            continue;
                                                        }
                                                        if (!action.equals("changedest")) break block99;
                                                        polddest = hprops.getProperty("olddest");
                                                        if (polddest == null) break block100;
                                                        pod = new Destination(polddest);
                                                        pod2 = router.lookupAll(key);
                                                        if (pod2 != null) break block101;
                                                        if (!he.hasValidInnerSig()) {
                                                            Daemon.logInner(log, action, key, addressbook);
                                                            ++invalid;
                                                            continue;
                                                        }
                                                        break block89;
                                                    }
                                                    if (pod2.contains(dest)) {
                                                        ++old;
                                                        continue;
                                                    }
                                                    if (!pod2.contains(pod)) break block102;
                                                    if (!he.hasValidInnerSig()) {
                                                        Daemon.logInner(log, action, key, addressbook);
                                                        ++invalid;
                                                        continue;
                                                    }
                                                    if (log != null) {
                                                        if (pod2.size() == 1) {
                                                            log.append("Changing destination for " + key + ". From: " + addressbook.getLocation());
                                                        } else {
                                                            log.append("Replacing " + pod2.size() + " destinations for " + key + ". From: " + addressbook.getLocation());
                                                        }
                                                    }
                                                    allowExistingKeyInPublished = true;
                                                    props.setProperty("m", Long.toString(I2PAppContext.getGlobalContext().clock().now()));
                                                    break block89;
                                                }
                                                Daemon.logMismatch(log, action, key, pod2, polddest, addressbook);
                                                ++invalid;
                                                continue;
                                            }
                                            Daemon.logMissing(log, action, key, addressbook);
                                            ++invalid;
                                            continue;
                                        }
                                        if (!action.equals("changename")) break block103;
                                        if (isKnown) {
                                            ++old;
                                            continue;
                                        }
                                        poldname = hprops.getProperty("oldname");
                                        if (poldname == null) break block104;
                                        pod = router.lookupAll(poldname);
                                        if (pod == null) break block89;
                                        if (!pod.contains(dest)) break block105;
                                        if (knownNames != null) {
                                            knownNames.remove(poldname);
                                        }
                                        if (success = router.remove(poldname, dest)) {
                                            ++deleted;
                                        }
                                        if (log != null) {
                                            if (success) {
                                                log.append("Removed: " + poldname + " to be replaced with " + key + ". From: " + addressbook.getLocation());
                                            } else {
                                                log.append("Remove failed for: " + poldname + " to be replaced with " + key + ". From: " + addressbook.getLocation());
                                            }
                                        }
                                        if (publishedNS == null) break block89;
                                        success = publishedNS.remove(poldname, dest);
                                        if (log == null || success) break block89;
                                        log.append("Remove from published address book " + publishedNS.getName() + " failed for " + poldname);
                                        break block89;
                                    }
                                    Daemon.logMismatch(log, action, key, pod, he.getDest(), addressbook);
                                    continue;
                                }
                                Daemon.logMissing(log, action, key, addressbook);
                                ++invalid;
                                continue;
                            }
                            if (action.equals("remove") || action.equals("removeall")) {
                                if (log != null) {
                                    log.append("Action: " + action + " with name=dest invalid. From: " + addressbook.getLocation());
                                }
                                ++invalid;
                                continue;
                            }
                            if (action.equals("update")) {
                                if (isKnown) {
                                    allowExistingKeyInPublished = true;
                                    props.setProperty("m", Long.toString(I2PAppContext.getGlobalContext().clock().now()));
                                }
                            } else {
                                if (log != null) {
                                    log.append("Action: " + action + " unrecognized. From: " + addressbook.getLocation());
                                }
                                ++invalid;
                                continue;
                            }
                        }
                        boolean success = router.put(key, dest, props);
                        if (log != null) {
                            if (success) {
                                log.append("New address " + key + " added to address book. From: " + addressbook.getLocation());
                            } else {
                                log.append("Save to naming service " + router + " failed for new key " + key);
                            }
                        }
                        if (publishedNS != null) {
                            success = allowExistingKeyInPublished ? publishedNS.put(key, dest, props) : publishedNS.putIfAbsent(key, dest, props);
                            if (log != null && !success) {
                                log.append("Save to published address book " + publishedNS.getName() + " failed for new key " + key);
                            }
                        }
                        if (knownNames != null) {
                            knownNames.add(key);
                        }
                        ++nnew;
                        continue;
                    }
                    if (key == null) {
                        if (action != null) {
                            String polddest;
                            if (action.equals("remove")) {
                                polddest = hprops.getProperty("dest");
                                String poldname = hprops.getProperty("name");
                                if (polddest != null && poldname != null) {
                                    Destination pod = new Destination(polddest);
                                    List<Destination> pod2 = router.lookupAll(poldname);
                                    if (pod2 != null && pod2.contains(pod)) {
                                        boolean success;
                                        if (knownNames != null && pod2.size() == 1) {
                                            knownNames.remove(poldname);
                                        }
                                        if (success = router.remove(poldname, pod)) {
                                            ++deleted;
                                        }
                                        if (log != null) {
                                            if (success) {
                                                log.append("Removed: " + poldname + " as requested. From: " + addressbook.getLocation());
                                            } else {
                                                log.append("Remove failed for: " + poldname + " as requested. From: " + addressbook.getLocation());
                                            }
                                        }
                                        if (publishedNS == null) continue;
                                        success = publishedNS.remove(poldname, pod);
                                        if (log == null || success) continue;
                                        log.append("Remove from published address book " + publishedNS.getName() + " failed for " + poldname);
                                        continue;
                                    }
                                    if (pod2 != null) {
                                        Daemon.logMismatch(log, action, key, pod2, polddest, addressbook);
                                        ++invalid;
                                        continue;
                                    }
                                    ++old;
                                    continue;
                                }
                                Daemon.logMissing(log, action, "delete", addressbook);
                                ++invalid;
                                continue;
                            }
                            if (action.equals("removeall")) {
                                polddest = hprops.getProperty("dest");
                                if (polddest != null) {
                                    List<String> revs;
                                    Destination pod = new Destination(polddest);
                                    String poldname = hprops.getProperty("name");
                                    if (poldname != null) {
                                        List<Destination> pod2 = router.lookupAll(poldname);
                                        if (pod2 != null && pod2.contains(pod)) {
                                            boolean success;
                                            if (knownNames != null) {
                                                knownNames.remove(poldname);
                                            }
                                            if (success = router.remove(poldname, pod)) {
                                                ++deleted;
                                            }
                                            if (log != null) {
                                                if (success) {
                                                    log.append("Removed: " + poldname + " as requested. From: " + addressbook.getLocation());
                                                } else {
                                                    log.append("Remove failed for: " + poldname + " as requested. From: " + addressbook.getLocation());
                                                }
                                            }
                                            if (publishedNS != null) {
                                                success = publishedNS.remove(poldname, pod);
                                                if (log != null && !success) {
                                                    log.append("Remove from published address book " + publishedNS.getName() + " failed for " + poldname);
                                                }
                                            }
                                        } else if (pod2 != null) {
                                            Daemon.logMismatch(log, action, key, pod2, polddest, addressbook);
                                            ++invalid;
                                        } else {
                                            ++old;
                                        }
                                    }
                                    if ((revs = router.reverseLookupAll(pod)) == null) continue;
                                    for (String rev : revs) {
                                        boolean success;
                                        if (knownNames != null) {
                                            knownNames.remove(rev);
                                        }
                                        if (success = router.remove(rev, pod)) {
                                            ++deleted;
                                        }
                                        if (log != null) {
                                            if (success) {
                                                log.append("Removed: " + rev + " as requested. From: " + addressbook.getLocation());
                                            } else {
                                                log.append("Remove failed for: " + rev + " as requested. From: " + addressbook.getLocation());
                                            }
                                        }
                                        if (publishedNS == null) continue;
                                        success = publishedNS.remove(rev, pod);
                                        if (log == null || success) continue;
                                        log.append("Remove from published address book " + publishedNS.getName() + " failed for " + rev);
                                    }
                                    continue;
                                }
                                Daemon.logMissing(log, action, "delete", addressbook);
                                ++invalid;
                                continue;
                            }
                            if (log != null) {
                                log.append("Action: " + action + " w/o name=dest unrecognized. From: " + addressbook.getLocation());
                            }
                            ++invalid;
                            continue;
                        }
                        if (log != null) {
                            log.append("No action in command line. From: " + addressbook.getLocation());
                        }
                        ++invalid;
                        continue;
                    }
                    if (log == null) continue;
                    log.append("Bad hostname " + key + ". From: " + addressbook.getLocation());
                    ++invalid;
                    continue;
                }
                ++old;
            }
            catch (DataFormatException dfe) {
                if (log != null) {
                    log.append("Invalid b64 for " + key + " From: " + addressbook.getLocation());
                }
                ++invalid;
            }
        }
        if (nnew > 0 && (cmgr = I2PAppContext.getGlobalContext().clientAppManager()) != null) {
            int nc = cmgr.getBubbleCount("susidns") + nnew;
            String msg = Daemon.ngettext("{0} new host", "{0} new hosts", nc);
            cmgr.setBubble("susidns", nc, msg);
        }
    }

    private static String ngettext(String s, String p, int n) {
        return Translate.getString(n, s, p, I2PAppContext.getGlobalContext(), "net.i2p.router.web.messages");
    }

    private static void logInner(Log log, String action, String name, AddressBook addressbook) {
        if (log != null) {
            log.append("Action: " + action + " failed because inner signature for key " + name + " failed. From: " + addressbook.getLocation());
        }
    }

    private static void logMissing(Log log, String action, String name, AddressBook addressbook) {
        if (log != null) {
            log.append("Action: " + action + " for " + name + " failed, missing required parameters. From: " + addressbook.getLocation());
        }
    }

    private static void logMismatch(Log log, String action, String name, List<Destination> dests, String olddest, AddressBook addressbook) {
        if (log != null) {
            StringBuilder buf = new StringBuilder(16);
            int sz = dests.size();
            for (int i = 0; i < sz; ++i) {
                buf.append(dests.get(i).toBase64(), 0, 6);
                if (i == sz - 1) continue;
                buf.append(", ");
            }
            log.append("Action: " + action + " failed because destinations for " + name + " (" + buf + ')' + " do not include (" + olddest.substring(0, 6) + ')' + ". From: " + addressbook.getLocation());
        }
    }

    public static void update(Map<String, String> settings, String home) {
        Log log;
        long delay;
        File published = null;
        boolean should_publish = Boolean.parseBoolean(settings.get("should_publish"));
        if (should_publish) {
            published = new File(home, settings.get("published_addressbook"));
        }
        File subscriptionFile = new File(home, settings.get("subscriptions"));
        File logFile = new File(home, settings.get("log"));
        File etagsFile = new File(home, settings.get("etags"));
        File lastModifiedFile = new File(home, settings.get("last_modified"));
        File lastFetchedFile = new File(home, settings.get("last_fetched"));
        try {
            delay = Long.parseLong(settings.get("update_delay"));
        }
        catch (NumberFormatException nfe) {
            delay = 12L;
        }
        ArrayList<String> defaultSubs = new ArrayList<String>(4);
        defaultSubs.add(DEFAULT_SUB);
        SubscriptionList subscriptions = new SubscriptionList(subscriptionFile, etagsFile, lastModifiedFile, lastFetchedFile, delay *= 3600000L, defaultSubs, settings.get("proxy_host"), Integer.parseInt(settings.get("proxy_port")));
        Log log2 = log = SystemVersion.isAndroid() ? null : new Log(logFile);
        if (Boolean.parseBoolean(settings.get("update_direct"))) {
            AddressBook local;
            File routerFile = new File(home, settings.get("router_addressbook"));
            if (should_publish) {
                File localFile = new File(home, settings.get("local_addressbook"));
                local = new AddressBook(localFile);
            } else {
                local = null;
            }
            AddressBook router = new AddressBook(routerFile);
            Daemon.update(local, router, published, subscriptions, log);
        } else {
            Daemon.update(Daemon.getNamingService(settings.get("naming_service")), published, subscriptions, log);
        }
    }

    private static NamingService searchNamingService(NamingService ns, String srch) {
        String name = ns.getName();
        if (name.equals(srch) || name.endsWith('/' + srch) || name.endsWith('\\' + srch)) {
            return ns;
        }
        List<NamingService> list = ns.getNamingServices();
        if (list != null) {
            for (NamingService nss : list) {
                NamingService rv = Daemon.searchNamingService(nss, srch);
                if (rv == null) continue;
                return rv;
            }
        }
        return null;
    }

    private static NamingService getNamingService(String srch) {
        NamingService root = I2PAppContext.getGlobalContext().namingService();
        NamingService rv = Daemon.searchNamingService(root, srch);
        return rv != null ? rv : root;
    }

    public static void main(String[] args) {
        Daemon daemon = new Daemon();
        if (args.length > 0 && args[0].equals("test")) {
            Daemon.test(args);
        } else {
            daemon.run(args);
        }
    }

    public static void test(String[] args) {
        Properties ctxProps = new Properties();
        String PROP_FORCE = "i2p.naming.blockfile.writeInAppContext";
        ctxProps.setProperty(PROP_FORCE, "true");
        I2PAppContext ctx = new I2PAppContext(ctxProps);
        NamingService ns = Daemon.getNamingService("hosts.txt");
        File published = new File("test-published.txt");
        Log log = new Log(new File("test-log.txt"));
        SubscriptionList subscriptions = new SubscriptionList("test-sub.txt");
        Daemon.update(ns, published, subscriptions, log);
        ctx.logManager().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        boolean created;
        SecureDirectory homeFile;
        this._running = true;
        String settingsLocation = "config.txt";
        if (args != null && args.length > 0) {
            homeFile = new SecureDirectory(args[0]);
            if (!homeFile.isAbsolute()) {
                homeFile = new SecureDirectory(I2PAppContext.getGlobalContext().getRouterDir(), args[0]);
            }
        } else {
            homeFile = new SecureDirectory(System.getProperty("user.dir"));
        }
        HashMap<String, String> defaultSettings = new HashMap<String, String>();
        defaultSettings.put("proxy_host", "127.0.0.1");
        defaultSettings.put("proxy_port", "4444");
        defaultSettings.put("local_addressbook", "../userhosts.txt");
        defaultSettings.put("router_addressbook", "../hosts.txt");
        defaultSettings.put("published_addressbook", "../eepsite/docroot/hosts.txt");
        defaultSettings.put("should_publish", "false");
        defaultSettings.put("log", "log.txt");
        defaultSettings.put("subscriptions", "subscriptions.txt");
        defaultSettings.put("etags", "etags");
        defaultSettings.put("last_modified", "last_modified");
        defaultSettings.put("last_fetched", "last_fetched");
        defaultSettings.put("update_delay", "12");
        defaultSettings.put("update_direct", "false");
        defaultSettings.put("naming_service", "hosts.txt");
        if (!homeFile.exists() && !(created = ((File)homeFile).mkdirs())) {
            System.out.println("ERROR: Addressbook directory " + homeFile.getAbsolutePath() + " could not be created");
        }
        File settingsFile = new File(homeFile, settingsLocation);
        Map<String, String> settings = ConfigParser.parse(settingsFile, defaultSettings);
        try {
            Thread.sleep(300000L + I2PAppContext.getGlobalContext().random().nextLong(300000L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this._running) {
            long delay = Long.parseLong(settings.get("update_delay"));
            if (delay < 1L) {
                delay = 1L;
            }
            Daemon.update(settings, homeFile.getAbsolutePath());
            try {
                Daemon daemon = this;
                synchronized (daemon) {
                    this.wait(delay * 60L * 60L * 1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this._running) break;
            settings = ConfigParser.parse(settingsFile, defaultSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Daemon daemon = this;
        synchronized (daemon) {
            this.notifyAll();
        }
    }

    public void stop() {
        this._running = false;
        this.wakeup();
    }
}

