/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.net.Socket;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.List;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.stack.StunStack;

public class TcpHostCandidate
extends HostCandidate {
    private final List<IceSocketWrapper> sockets = new LinkedList<IceSocketWrapper>();

    public TcpHostCandidate(TransportAddress transportAddress, Component parentComponent) {
        super(transportAddress, parentComponent);
    }

    @Override
    protected IceSocketWrapper getCandidateIceSocketWrapper(SocketAddress remoteAddress) {
        for (IceSocketWrapper socket : this.sockets) {
            if (!socket.getTCPSocket().getRemoteSocketAddress().equals(remoteAddress)) continue;
            return socket;
        }
        return null;
    }

    public void addSocket(IceSocketWrapper socket) {
        this.sockets.add(socket);
    }

    @Override
    protected void free() {
        StunStack stunStack = this.getStunStack();
        TransportAddress localAddr = this.getTransportAddress();
        for (IceSocketWrapper socket : this.sockets) {
            Socket tcpSocket = socket.getTCPSocket();
            stunStack.removeSocket(localAddr, new TransportAddress(tcpSocket.getInetAddress(), tcpSocket.getPort(), Transport.TCP));
            socket.close();
        }
        super.free();
    }
}

