/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizerPlan;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.OptimizerImpl;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class XMLOptTrace
implements OptTrace {
    private static final String STMT = "statement";
    private static final String STMT_ID = "stmtID";
    private static final String STMT_TEXT = "stmtText";
    private static final String QBLOCK = "queryBlock";
    private static final String QBLOCK_OPTIMIZER_ID = "qbOptimizerID";
    private static final String QBLOCK_START_TIME = "qbStartTime";
    private static final String QBLOCK_ID = "qbID";
    private static final String QBLOCK_OPTIMIZABLE = "qbOptimizable";
    private static final String QBLOCK_OPT_TABLE_NUMBER = "qboTableNumber";
    private static final String QBLOCK_TIMEOUT = "qbTimeout";
    private static final String QBLOCK_VACUOUS = "qbVacuous";
    private static final String QBLOCK_SORT_COST = "qbSortCost";
    private static final String QBLOCK_TOTAL_COST = "qbTotalCost";
    private static final String QBLOCK_NO_BEST_PLAN = "qbNoBestPlan";
    private static final String QBLOCK_SKIP = "qbSkip";
    private static final String JO = "joinOrder";
    private static final String JO_COMPLETE = "joComplete";
    private static final String JO_SLOT = "joSlot";
    private static final String DECORATION = "decoration";
    private static final String DECORATION_CONGLOM_NAME = "decConglomerateName";
    private static final String DECORATION_KEY = "decKey";
    private static final String DECORATION_TABLE_NAME = "decTableName";
    private static final String DECORATION_JOIN_STRATEGY = "decJoinStrategy";
    private static final String DECORATION_SKIP = "decSkip";
    private static final String DECORATION_CONGLOM_COST = "decConglomerateCost";
    private static final String DECORATION_FIRST_COLUMN_SELECTIVITY = "decExtraFirstColumnPreds";
    private static final String DECORATION_EXTRA_START_STOP_SELECTIVITY = "decExtraFirstStartStopPreds";
    private static final String DECORATION_START_STOP_SELECTIVITY = "decStartStopPred";
    private static final String DECORATION_EXTRA_QUALIFIERS = "decExtraQualifiers";
    private static final String DECORATION_EXTRA_NON_QUALIFIERS = "decExtraNonQualifiers";
    private static final String SKIP_REASON = "skipReason";
    private static final String PC = "planCost";
    private static final String PC_TYPE = "pcType";
    private static final String PC_COMPLETE = "pcComplete";
    private static final String PC_AVOID_SORT = "pcAvoidSort";
    private static final String PC_SUMMARY = "pcSummary";
    private static final String CE_ESTIMATED_COST = "ceEstimatedCost";
    private static final String CE_ROW_COUNT = "ceEstimatedRowCount";
    private static final String CE_SINGLE_SCAN_ROW_COUNT = "ceSingleScanRowCount";
    private static final String SEL_COUNT = "selCount";
    private static final String SEL_SELECTIVITY = "selSelectivity";
    private static final String TABLE_FUNCTION_FLAG = "()";
    static final String PLAN_COST_VTI = "create function planCost\n(\n    xmlResourceName varchar( 32672 ),\n    rowTag varchar( 32672 ),\n    parentTags ArrayList,\n    childTags ArrayList\n)\nreturns table\n(\n    text varchar( 32672 ),\n    stmtID    int,\n    qbID   int,\n    complete  boolean,\n    summary   varchar( 32672 ),\n    type        varchar( 50 ),\n    estimatedCost        double,\n    estimatedRowCount    bigint\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derby.vti.XmlVTI.xmlVTI'\n";
    static final String PLAN_COST_VIEW = "create view planCost as\nselect *\nfrom table\n(\n    planCost\n    (\n        'FILE_URL',\n        'planCost',\n        asList( 'stmtText', 'stmtID', 'qbID' ),\n        asList( 'pcComplete', 'pcSummary', 'pcType', 'ceEstimatedCost', 'ceEstimatedRowCount' )\n     )\n) v\n";
    private Document _doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
    private Element _root = this.createElement(null, "optimizerTrace", null);
    private Element _currentStatement;
    private int _currentStatementID;
    private QueryBlock _currentQueryBlock;
    private int _maxQueryID;
    private Stack<QueryBlock> _queryBlockStack;
    private ContextManager _cm;
    private LanguageConnectionContext _lcc;

    public XMLOptTrace() throws ParserConfigurationException {
        this._doc.appendChild(this._root);
    }

    @Override
    public void traceStartStatement(String statementText) {
        ++this._currentStatementID;
        this._maxQueryID = 0;
        this._currentQueryBlock = null;
        this._queryBlockStack = new Stack();
        this._currentStatement = this.createElement(this._root, STMT, null);
        this._currentStatement.setAttribute(STMT_ID, Integer.toString(this._currentStatementID));
        this.createElement(this._currentStatement, STMT_TEXT, statementText);
    }

    @Override
    public void traceStartQueryBlock(long timeOptimizationStarted, int optimizerID, OptimizableList optimizableList) {
        ++this._maxQueryID;
        if (this._currentQueryBlock != null) {
            this._queryBlockStack.push(this._currentQueryBlock);
        }
        Element queryElement = this.createElement(this._currentStatement, QBLOCK, null);
        queryElement.setAttribute(QBLOCK_OPTIMIZER_ID, Integer.toString(optimizerID));
        queryElement.setAttribute(QBLOCK_START_TIME, this.formatTimestamp(timeOptimizationStarted));
        queryElement.setAttribute(QBLOCK_ID, Integer.toString(this._maxQueryID));
        this._currentQueryBlock = new QueryBlock(this._maxQueryID, optimizableList, queryElement);
        if (optimizableList != null) {
            for (int i = 0; i < optimizableList.size(); ++i) {
                Optimizable opt = optimizableList.getOptimizable(i);
                if (this._cm == null) {
                    this._cm = ((QueryTreeNode)((Object)opt)).getContextManager();
                    this._lcc = (LanguageConnectionContext)this._cm.getContext("LanguageConnectionContext");
                }
                Element optElement = this.createElement(queryElement, QBLOCK_OPTIMIZABLE, this.getOptimizableName(opt).getFullSQLName());
                optElement.setAttribute(QBLOCK_OPT_TABLE_NUMBER, Integer.toString(opt.getTableNumber()));
            }
        }
    }

    @Override
    public void traceEndQueryBlock() {
        if (this._queryBlockStack.size() > 0) {
            this._currentQueryBlock = this._queryBlockStack.pop();
        }
    }

    @Override
    public void traceTimeout(long currentTime, CostEstimate bestCost) {
        Element timeout = this.createElement(this._currentQueryBlock.queryBlockElement, QBLOCK_TIMEOUT, null);
        this.formatCost(timeout, bestCost);
    }

    @Override
    public void traceVacuous() {
        this.createElement(this._currentQueryBlock.queryBlockElement, QBLOCK_VACUOUS, null);
    }

    @Override
    public void traceCompleteJoinOrder() {
        if (this._currentQueryBlock.currentJoinsElement != null) {
            this._currentQueryBlock.currentJoinsElement.setAttribute(JO_COMPLETE, "true");
        }
    }

    @Override
    public void traceSortCost(CostEstimate sortCost, CostEstimate currentCost) {
        Element sc = this.createElement(this._currentQueryBlock.queryBlockElement, QBLOCK_SORT_COST, null);
        this.formatCost(sc, sortCost);
        Element tcis = this.createElement(this._currentQueryBlock.queryBlockElement, QBLOCK_TOTAL_COST, null);
        this.formatCost(tcis, currentCost);
    }

    @Override
    public void traceNoBestPlan() {
        this.createElement(this._currentQueryBlock.queryBlockElement, QBLOCK_NO_BEST_PLAN, null);
    }

    @Override
    public void traceModifyingAccessPaths(int optimizerID) {
    }

    @Override
    public void traceShortCircuiting(boolean timeExceeded, Optimizable thisOpt, int joinPosition) {
    }

    @Override
    public void traceSkippingJoinOrder(int nextOptimizable, int joinPosition, int[] proposedJoinOrder, JBitSet assignedTableMap) {
        Optimizable opt = this._currentQueryBlock.optimizableList.getOptimizable(nextOptimizable);
        Element skip = this.formatSkip(this._currentQueryBlock.queryBlockElement, QBLOCK_SKIP, "Useless join order. " + this.getOptimizableName(opt).getFullSQLName() + " depends on tables after it in the join order");
        this.formatJoinOrder(skip, proposedJoinOrder);
    }

    @Override
    public void traceIllegalUserJoinOrder() {
    }

    @Override
    public void traceUserJoinOrderOptimized() {
    }

    @Override
    public void traceJoinOrderConsideration(int joinPosition, int[] proposedJoinOrder, JBitSet assignedTableMap) {
        this._currentQueryBlock.currentJoinsElement = this.createElement(this._currentQueryBlock.queryBlockElement, JO, null);
        this._currentQueryBlock.currentJoinOrder = proposedJoinOrder;
        this._currentQueryBlock.currentDecorationStrategy = null;
        this._currentQueryBlock.currentDecoration = null;
        this.formatJoinOrder(this._currentQueryBlock.currentJoinsElement, proposedJoinOrder);
    }

    @Override
    public void traceCostWithoutSortAvoidance(CostEstimate currentCost) {
        this.formatPlanCost(this._currentQueryBlock.currentJoinsElement, "withoutSortAvoidance", this._currentQueryBlock.currentJoinOrder, 1, currentCost);
    }

    @Override
    public void traceCostWithSortAvoidance(CostEstimate currentSortAvoidanceCost) {
        this.formatPlanCost(this._currentQueryBlock.currentJoinsElement, "withSortAvoidance", this._currentQueryBlock.currentJoinOrder, 2, currentSortAvoidanceCost);
    }

    @Override
    public void traceCurrentPlanAvoidsSort(CostEstimate bestCost, CostEstimate currentSortAvoidanceCost) {
    }

    @Override
    public void traceCheapestPlanSoFar(int planType, CostEstimate currentCost) {
    }

    @Override
    public void traceSortNeededForOrdering(int planType, RequiredRowOrdering requiredRowOrdering) {
    }

    @Override
    public void traceRememberingBestJoinOrder(int joinPosition, int[] bestJoinOrder, int planType, CostEstimate planCost, JBitSet assignedTableMap) {
        if (this._currentQueryBlock.currentBestPlan != null) {
            this._currentQueryBlock.queryBlockElement.removeChild(this._currentQueryBlock.currentBestPlan);
        }
        this._currentQueryBlock.currentBestPlan = this.formatPlanCost(this._currentQueryBlock.queryBlockElement, "bestPlan", bestJoinOrder, planType, planCost);
    }

    @Override
    public void traceSkippingBecauseTooMuchMemory(int maxMemoryPerTable) {
        this.formatSkip(this._currentQueryBlock.currentDecoration, DECORATION_SKIP, "Exceeds limit on memory per table: " + maxMemoryPerTable);
    }

    @Override
    public void traceCostOfNScans(int tableNumber, double rowCount, CostEstimate cost) {
    }

    @Override
    public void traceSkipUnmaterializableHashJoin() {
        this.formatSkip(this._currentQueryBlock.currentDecoration, DECORATION_SKIP, "Hash strategy not possible because table is not materializable");
    }

    @Override
    public void traceSkipHashJoinNoHashKeys() {
        this.formatSkip(this._currentQueryBlock.currentDecoration, DECORATION_SKIP, "No hash keys");
    }

    @Override
    public void traceHashKeyColumns(int[] hashKeyColumns) {
    }

    @Override
    public void traceOptimizingJoinNode() {
    }

    @Override
    public void traceConsideringJoinStrategy(JoinStrategy js, int tableNumber) {
        this._currentQueryBlock.currentDecorationStrategy = js;
    }

    @Override
    public void traceRememberingBestAccessPath(AccessPath accessPath, int tableNumber, int planType) {
    }

    @Override
    public void traceNoMoreConglomerates(int tableNumber) {
    }

    @Override
    public void traceConsideringConglomerate(ConglomerateDescriptor cd, int tableNumber) {
        Optimizable opt = this.getOptimizable(tableNumber);
        this._currentQueryBlock.currentDecoration = this.createElement(this._currentQueryBlock.currentJoinsElement, DECORATION, null);
        this._currentQueryBlock.currentDecoration.setAttribute(DECORATION_CONGLOM_NAME, cd.getConglomerateName());
        this._currentQueryBlock.currentDecoration.setAttribute(DECORATION_TABLE_NAME, this.getOptimizableName(opt).toString());
        this._currentQueryBlock.currentDecoration.setAttribute(DECORATION_JOIN_STRATEGY, this._currentQueryBlock.currentDecorationStrategy.getName());
        String[] columnNames = cd.getColumnNames();
        if (cd.isIndex() && columnNames != null) {
            int[] keyColumns = cd.getIndexDescriptor().baseColumnPositions();
            for (int i = 0; i < keyColumns.length; ++i) {
                this.createElement(this._currentQueryBlock.currentDecoration, DECORATION_KEY, columnNames[keyColumns[i] - 1]);
            }
        }
    }

    @Override
    public void traceScanningHeapWithUniqueKey() {
    }

    @Override
    public void traceAddingUnorderedOptimizable(int predicateCount) {
    }

    @Override
    public void traceChangingAccessPathForTable(int tableNumber) {
    }

    @Override
    public void traceNoStartStopPosition() {
    }

    @Override
    public void traceNonCoveringIndexCost(double cost, int tableNumber) {
    }

    @Override
    public void traceConstantStartStopPositions() {
    }

    @Override
    public void traceEstimatingCostOfConglomerate(ConglomerateDescriptor cd, int tableNumber) {
    }

    @Override
    public void traceLookingForSpecifiedIndex(String indexName, int tableNumber) {
    }

    @Override
    public void traceSingleMatchedRowCost(double cost, int tableNumber) {
    }

    @Override
    public void traceCostIncludingExtra1stColumnSelectivity(CostEstimate cost, int tableNumber) {
    }

    @Override
    public void traceNextAccessPath(String baseTable, int predicateCount) {
    }

    @Override
    public void traceCostIncludingExtraStartStop(CostEstimate cost, int tableNumber) {
    }

    @Override
    public void traceCostIncludingExtraQualifierSelectivity(CostEstimate cost, int tableNumber) {
    }

    @Override
    public void traceCostIncludingExtraNonQualifierSelectivity(CostEstimate cost, int tableNumber) {
    }

    @Override
    public void traceCostOfNoncoveringIndex(CostEstimate cost, int tableNumber) {
    }

    @Override
    public void traceRememberingJoinStrategy(JoinStrategy joinStrategy, int tableNumber) {
    }

    @Override
    public void traceRememberingBestAccessPathSubstring(AccessPath ap, int tableNumber) {
    }

    @Override
    public void traceRememberingBestSortAvoidanceAccessPathSubstring(AccessPath ap, int tableNumber) {
    }

    @Override
    public void traceRememberingBestUnknownAccessPathSubstring(AccessPath ap, int tableNumber) {
    }

    @Override
    public void traceCostOfConglomerateScan(int tableNumber, ConglomerateDescriptor cd, CostEstimate costEstimate, int numExtraFirstColumnPreds, double extraFirstColumnSelectivity, int numExtraStartStopPreds, double extraStartStopSelectivity, int startStopPredCount, double statStartStopSelectivity, int numExtraQualifiers, double extraQualifierSelectivity, int numExtraNonQualifiers, double extraNonQualifierSelectivity) {
        Element cost = this.createElement(this._currentQueryBlock.currentDecoration, DECORATION_CONGLOM_COST, null);
        cost.setAttribute("name", cd.getConglomerateName());
        this.formatCost(cost, costEstimate);
        this.formatSelectivity(cost, DECORATION_FIRST_COLUMN_SELECTIVITY, numExtraFirstColumnPreds, extraFirstColumnSelectivity);
        this.formatSelectivity(cost, DECORATION_EXTRA_START_STOP_SELECTIVITY, numExtraStartStopPreds, extraStartStopSelectivity);
        this.formatSelectivity(cost, DECORATION_START_STOP_SELECTIVITY, startStopPredCount, statStartStopSelectivity);
        this.formatSelectivity(cost, DECORATION_EXTRA_QUALIFIERS, numExtraQualifiers, extraQualifierSelectivity);
        this.formatSelectivity(cost, DECORATION_EXTRA_NON_QUALIFIERS, numExtraNonQualifiers, extraNonQualifierSelectivity);
    }

    @Override
    public void traceCostIncludingCompositeSelectivityFromStats(CostEstimate cost, int tableNumber) {
    }

    @Override
    public void traceCompositeSelectivityFromStatistics(double statCompositeSelectivity) {
    }

    @Override
    public void traceCostIncludingStatsForIndex(CostEstimate cost, int tableNumber) {
    }

    @Override
    public void printToWriter(PrintWriter out) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this._doc);
            StreamResult result = new StreamResult(out);
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(source, result);
        }
        catch (Throwable t) {
            this.printThrowable(t);
        }
    }

    private Optimizable getOptimizable(int tableNumber) {
        for (int i = 0; i < this._currentQueryBlock.optimizableList.size(); ++i) {
            Optimizable candidate = this._currentQueryBlock.optimizableList.getOptimizable(i);
            if (tableNumber != candidate.getTableNumber()) continue;
            return candidate;
        }
        return null;
    }

    private TableName getOptimizableName(Optimizable optimizable) {
        try {
            TableName retval;
            if (this.isBaseTable(optimizable)) {
                ProjectRestrictNode prn = (ProjectRestrictNode)optimizable;
                TableDescriptor td = ((FromBaseTable)prn.getChildResult()).getTableDescriptor();
                return this.makeTableName(td.getSchemaName(), td.getName(), this._cm);
            }
            if (OptimizerImpl.isTableFunction(optimizable)) {
                ProjectRestrictNode prn = (ProjectRestrictNode)optimizable;
                AliasDescriptor ad = ((StaticMethodCallNode)((FromVTI)prn.getChildResult()).getMethodCall()).ad;
                return this.makeTableName(ad.getSchemaName(), ad.getName(), this._cm);
            }
            if (this.isFromTable(optimizable) && (retval = ((FromTable)((ProjectRestrictNode)optimizable).getChildResult()).getTableName()) != null) {
                return retval;
            }
        }
        catch (StandardException retval) {
            // empty catch block
        }
        String nodeClass = optimizable.getClass().getName();
        String unqualifiedName = nodeClass.substring(nodeClass.lastIndexOf(".") + 1);
        return this.makeTableName(null, unqualifiedName, this._cm);
    }

    private boolean isBaseTable(Optimizable optimizable) {
        if (!(optimizable instanceof ProjectRestrictNode)) {
            return false;
        }
        ResultSetNode rsn = ((ProjectRestrictNode)optimizable).getChildResult();
        return rsn instanceof FromBaseTable;
    }

    private boolean isFromTable(Optimizable optimizable) {
        if (!(optimizable instanceof ProjectRestrictNode)) {
            return false;
        }
        ResultSetNode rsn = ((ProjectRestrictNode)optimizable).getChildResult();
        return rsn instanceof FromTable;
    }

    private TableName makeTableName(String schemaName, String unqualifiedName, ContextManager cm) {
        TableName result = new TableName(schemaName, unqualifiedName, cm);
        return result;
    }

    private void printThrowable(Throwable t) {
        t.printStackTrace(Monitor.getStream().getPrintWriter());
    }

    private Element createElement(Element parent, String tag, String content) {
        Element child = null;
        try {
            child = this._doc.createElement(tag);
            if (parent != null) {
                parent.appendChild(child);
            }
            if (content != null) {
                child.setTextContent(content);
            }
        }
        catch (Throwable t) {
            this.printThrowable(t);
        }
        return child;
    }

    private String formatTimestamp(long timestamp) {
        return new Date(timestamp).toString();
    }

    private Element formatSkip(Element parent, String skipTag, String reason) {
        Element skip = this.createElement(parent, skipTag, null);
        skip.setAttribute(SKIP_REASON, reason);
        return skip;
    }

    private Element formatPlanCost(Element parent, String type, int[] planOrder, int planType, CostEstimate raw) {
        Element cost = this.createElement(parent, PC, null);
        cost.setAttribute(PC_TYPE, type);
        if (this.isComplete(planOrder)) {
            cost.setAttribute(PC_COMPLETE, "true");
        }
        if (planType == 2) {
            cost.setAttribute(PC_AVOID_SORT, "true");
        }
        this.createElement(cost, PC_SUMMARY, this.formatPlanSummary(planOrder, planType));
        this.formatCost(cost, raw);
        return cost;
    }

    private boolean isComplete(int[] joinOrder) {
        if (joinOrder == null) {
            return false;
        }
        if (joinOrder.length < this._currentQueryBlock.optimizableList.size()) {
            return false;
        }
        for (int i = 0; i < joinOrder.length; ++i) {
            if (joinOrder[i] >= 0) continue;
            return false;
        }
        return true;
    }

    private void formatCost(Element costElement, CostEstimate raw) {
        this.createElement(costElement, CE_ESTIMATED_COST, Double.toString(raw.getEstimatedCost()));
        this.createElement(costElement, CE_ROW_COUNT, Long.toString(raw.getEstimatedRowCount()));
        this.createElement(costElement, CE_SINGLE_SCAN_ROW_COUNT, Double.toString(raw.singleScanRowCount()));
    }

    private void formatSelectivity(Element parent, String tag, int count, double selectivity) {
        Element child = this.createElement(parent, tag, null);
        child.setAttribute(SEL_COUNT, Integer.toString(count));
        child.setAttribute(SEL_SELECTIVITY, Double.toString(selectivity));
    }

    private void formatJoinOrder(Element parent, int[] proposedJoinOrder) {
        if (proposedJoinOrder != null) {
            for (int idx = 0; idx < proposedJoinOrder.length; ++idx) {
                int optimizableNumber = proposedJoinOrder[idx];
                if (optimizableNumber < 0) continue;
                Optimizable optimizable = this._currentQueryBlock.optimizableList.getOptimizable(optimizableNumber);
                this.createElement(parent, JO_SLOT, this.getOptimizableName(optimizable).getFullSQLName());
            }
        }
    }

    private String formatPlanSummary(int[] planOrder, int planType) {
        try {
            int planLength;
            Object plan = null;
            StringBuilder buffer = new StringBuilder();
            boolean avoidSort = planType == 2;
            for (planLength = 0; planLength < planOrder.length && planOrder[planLength] >= 0; ++planLength) {
            }
            for (int i = 0; i < planLength; ++i) {
                OptimizerPlan current;
                int listIndex = planOrder[i];
                if (listIndex >= this._currentQueryBlock.optimizableList.size()) {
                    buffer.append("{ UNKNOWN LIST INDEX " + listIndex + " } ");
                    continue;
                }
                Optimizable optimizable = this._currentQueryBlock.optimizableList.getOptimizable(listIndex);
                AccessPath ap = avoidSort ? optimizable.getBestSortAvoidancePath() : optimizable.getBestAccessPath();
                JoinStrategy js = ap.getJoinStrategy();
                ConglomerateDescriptor utd = OptimizerImpl.isTableFunction(optimizable) ? ((StaticMethodCallNode)((FromVTI)((ProjectRestrictNode)optimizable).getChildResult()).getMethodCall()).ad : ap.getConglomerateDescriptor();
                OptimizerPlan optimizerPlan = current = utd == null ? new OptimizerPlan.DeadEnd(this.getOptimizableName(optimizable).toString()) : OptimizerPlan.makeRowSource(utd, this._lcc.getDataDictionary());
                if (plan != null) {
                    current = new OptimizerPlan.Join(js, (OptimizerPlan)plan, current);
                }
                plan = current;
            }
            return plan.toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static final class QueryBlock {
        final int queryBlockID;
        final OptimizableList optimizableList;
        final Element queryBlockElement;
        Element currentJoinsElement;
        int[] currentJoinOrder;
        Element currentBestPlan;
        JoinStrategy currentDecorationStrategy;
        Element currentDecoration;

        public QueryBlock(int queryBlockID, OptimizableList optimizableList, Element queryBlockElement) {
            this.queryBlockID = queryBlockID;
            this.optimizableList = optimizableList;
            this.queryBlockElement = queryBlockElement;
        }
    }
}

