/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class BulkTableScanResultSet
extends TableScanResultSet
implements CursorResultSet {
    private DataValueDescriptor[][] rowArray;
    private RowLocation[] rowLocations;
    private int curRowPosition;
    private int numRowsInArray;
    private int baseColumnCount;
    private int resultColumnCount;
    private static int OUT_OF_ROWS = 0;

    BulkTableScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, int resultRowTemplate, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int rowsPerRead, boolean disableForHoldable, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(conglomId, scoci, activation, resultRowTemplate, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, qualifiers, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, colRefItem, indexColItem, lockMode, tableLocked, isolationLevel, BulkTableScanResultSet.adjustBulkFetchSize(activation, rowsPerRead, disableForHoldable), oneRowScan, optimizerEstimatedRowCount, optimizerEstimatedCost);
        if (rowsPerRead == 1) {
            SanityManager.THROWASSERT((String)"rowsPerRead not expected to be 1");
        }
        if (oneRowScan) {
            SanityManager.THROWASSERT((String)("oneRowScan expected to be false - rowsPerRead = " + rowsPerRead));
        }
        this.setRowLocationsState();
        if (this.fetchRowLocations) {
            this.resultColumnCount = this.accessedCols == null ? this.candidate.nColumns() : this.accessedCols.getNumBitsSet();
            this.baseColumnCount = this.candidate.nColumns() - 1;
            this.candidate.setRowArray(this.lopOffRowLocation());
            if (this.accessedCols == null) {
                this.accessedCols = new FormatableBitSet(this.baseColumnCount);
                for (int i = 0; i < this.baseColumnCount; ++i) {
                    this.accessedCols.set(i);
                }
            } else {
                FormatableBitSet newCols = new FormatableBitSet(this.baseColumnCount);
                for (int i = 0; i < this.baseColumnCount; ++i) {
                    if (!this.accessedCols.isSet(i)) continue;
                    newCols.set(i);
                }
                this.accessedCols = newCols;
            }
        }
    }

    private static int adjustBulkFetchSize(Activation activation, int rowsPerRead, boolean disableForHoldable) {
        if (disableForHoldable && activation.getResultSetHoldability()) {
            return 1;
        }
        return rowsPerRead;
    }

    @Override
    protected void openScanController(TransactionController tc) throws StandardException {
        DataValueDescriptor[] stopPositionRow;
        DataValueDescriptor[] startPositionRow = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray = stopPositionRow = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        if (tc == null) {
            tc = this.activation.getTransactionController();
        }
        this.scanController = tc.openCompiledScan(this.activation.getResultSetHoldability(), this.forUpdate ? 4 : 0, this.lockMode, this.isolationLevel, this.accessedCols, startPositionRow, this.startSearchOperator, this.qualifiers, stopPositionRow, this.stopSearchOperator, this.scoci, this.dcoci);
        this.scanControllerOpened = true;
        this.rowsThisScan = 0L;
        this.activation.informOfRowCount(this, this.scanController.getEstimatedRowCount());
    }

    @Override
    public void openCore() throws StandardException {
        super.openCore();
        this.beginTime = this.getCurrentTimeMillis();
        this.rowArray = new DataValueDescriptor[this.rowsPerRead][];
        if (this.fetchRowLocations) {
            this.rowLocations = new RowLocation[this.rowsPerRead];
        }
        this.rowArray[0] = this.candidate.getRowArrayClone();
        this.numRowsInArray = 0;
        this.curRowPosition = -1;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private DataValueDescriptor[] lopOffRowLocation() throws StandardException {
        DataValueDescriptor[] temp = this.candidate.getRowArrayClone();
        int count = temp.length - 1;
        DataValueDescriptor[] result = new DataValueDescriptor[count];
        for (int i = 0; i < count; ++i) {
            result[i] = temp[i];
        }
        return result;
    }

    @Override
    public void reopenCore() throws StandardException {
        super.reopenCore();
        this.numRowsInArray = 0;
        this.curRowPosition = -1;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow result = null;
        this.checkCancellationFlag();
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen && this.scanControllerOpened) {
            if (this.currentRow == null) {
                this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed);
            }
            block0: while (true) {
                if (this.curRowPosition >= this.numRowsInArray - 1 && this.reloadArray() == OUT_OF_ROWS) {
                    this.clearCurrentRow();
                    this.setRowCountIfPossible(this.rowsThisScan);
                    return null;
                }
                while (true) {
                    if (++this.curRowPosition >= this.numRowsInArray) continue block0;
                    this.candidate.setRowArray(this.rowArray[this.curRowPosition]);
                    this.currentRow = this.setCompactRow(this.candidate, this.currentRow);
                    ++this.rowsSeen;
                    ++this.rowsThisScan;
                    if (!this.skipRow(this.candidate)) break block0;
                    ++this.rowsFiltered;
                }
                break;
            }
            result = this.currentRow;
            if (this.fetchRowLocations) {
                int idx;
                result = new ValueRow(this.resultColumnCount);
                for (idx = 1; idx < this.resultColumnCount; ++idx) {
                    result.setColumn(idx, this.currentRow.getColumn(idx));
                }
                result.setColumn(idx, this.rowLocations[this.curRowPosition]);
            }
        }
        this.setCurrentRow(result);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    private int reloadArray() throws StandardException {
        this.curRowPosition = -1;
        this.numRowsInArray = ((GroupFetchScanController)((Object)this.scanController)).fetchNextGroup(this.rowArray, this.rowLocations);
        return this.numRowsInArray;
    }

    @Override
    public void close() throws StandardException {
        super.close();
        this.numRowsInArray = -1;
        this.curRowPosition = -1;
        this.rowArray = null;
        this.rowLocations = null;
    }

    @Override
    protected boolean canGetInstantaneousLocks() {
        return !this.forUpdate;
    }

    @Override
    public boolean requiresRelocking() {
        return this.isolationLevel == 2 || this.isolationLevel == 3 || this.isolationLevel == 1;
    }
}

