/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.io.ByteArrayInputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.jupnp.http.Headers;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpOperation;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.transport.spi.DatagramProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramProcessorImpl
implements DatagramProcessor {
    private final Logger logger = LoggerFactory.getLogger(DatagramProcessor.class);

    @Override
    public IncomingDatagramMessage read(InetAddress receivedOnAddress, DatagramPacket datagram) throws UnsupportedDataException {
        try {
            ByteArrayInputStream is;
            String[] startLine;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("===================================== DATAGRAM BEGIN ============================================");
                this.logger.trace(new String(datagram.getData()));
                this.logger.trace("-===================================== DATAGRAM END =============================================");
            }
            if ((startLine = Headers.readLine(is = new ByteArrayInputStream(datagram.getData())).split(" "))[0].startsWith("HTTP/1.")) {
                return this.readResponseMessage(receivedOnAddress, datagram, is, Integer.parseInt(startLine[1]), startLine[2], startLine[0]);
            }
            return this.readRequestMessage(receivedOnAddress, datagram, is, startLine[0], startLine[2]);
        }
        catch (Exception e) {
            throw new UnsupportedDataException("Could not parse headers", e, datagram.getData());
        }
    }

    @Override
    public DatagramPacket write(OutgoingDatagramMessage message) throws UnsupportedDataException {
        StringBuilder statusLine = new StringBuilder();
        Object operation = message.getOperation();
        if (operation instanceof UpnpRequest) {
            UpnpRequest requestOperation = (UpnpRequest)operation;
            statusLine.append(requestOperation.getHttpMethodName()).append(" * ");
            statusLine.append("HTTP/1.").append(((UpnpOperation)operation).getHttpMinorVersion()).append("\r\n");
        } else if (operation instanceof UpnpResponse) {
            UpnpResponse responseOperation = (UpnpResponse)operation;
            statusLine.append("HTTP/1.").append(((UpnpOperation)operation).getHttpMinorVersion()).append(" ");
            statusLine.append(responseOperation.getStatusCode()).append(" ").append(responseOperation.getStatusMessage());
            statusLine.append("\r\n");
        } else {
            throw new UnsupportedDataException("Message operation is not request or response, don't know how to process: " + String.valueOf(message));
        }
        StringBuilder messageData = new StringBuilder();
        messageData.append((CharSequence)statusLine);
        messageData.append(message.getHeaders().toString()).append("\r\n");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Writing message data for: {}", (Object)message);
            this.logger.trace("---------------------------------------------------------------------------------");
            this.logger.trace(messageData.substring(0, messageData.length() - 2));
            this.logger.trace("---------------------------------------------------------------------------------");
        }
        byte[] data = messageData.toString().getBytes(StandardCharsets.US_ASCII);
        this.logger.trace("Writing new datagram packet with {} bytes for: {}", (Object)data.length, (Object)message);
        return new DatagramPacket(data, data.length, message.getDestinationAddress(), message.getDestinationPort());
    }

    protected IncomingDatagramMessage readRequestMessage(InetAddress receivedOnAddress, DatagramPacket datagram, ByteArrayInputStream is, String requestMethod, String httpProtocol) throws Exception {
        UpnpHeaders headers = new UpnpHeaders(is);
        UpnpRequest upnpRequest = new UpnpRequest(UpnpRequest.Method.getByHttpName(requestMethod));
        upnpRequest.setHttpMinorVersion(httpProtocol.toUpperCase(Locale.ENGLISH).equals("HTTP/1.1") ? 1 : 0);
        IncomingDatagramMessage<UpnpRequest> requestMessage = new IncomingDatagramMessage<UpnpRequest>(upnpRequest, datagram.getAddress(), datagram.getPort(), receivedOnAddress);
        requestMessage.setHeaders(headers);
        return requestMessage;
    }

    protected IncomingDatagramMessage readResponseMessage(InetAddress receivedOnAddress, DatagramPacket datagram, ByteArrayInputStream is, int statusCode, String statusMessage, String httpProtocol) throws Exception {
        UpnpHeaders headers = new UpnpHeaders(is);
        UpnpResponse upnpResponse = new UpnpResponse(statusCode, statusMessage);
        upnpResponse.setHttpMinorVersion(httpProtocol.toUpperCase(Locale.ENGLISH).equals("HTTP/1.1") ? 1 : 0);
        IncomingDatagramMessage<UpnpResponse> responseMessage = new IncomingDatagramMessage<UpnpResponse>(upnpResponse, datagram.getAddress(), datagram.getPort(), receivedOnAddress);
        responseMessage.setHeaders(headers);
        return responseMessage;
    }
}

