/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.fop.util.QName;

public abstract class AreaTreeObject {
    protected Map foreignAttributes = null;

    public void setForeignAttribute(QName name, String value) {
        if (this.foreignAttributes == null) {
            this.foreignAttributes = new HashMap();
        }
        this.foreignAttributes.put(name, value);
    }

    public void setForeignAttributes(Map atts) {
        if (atts.size() == 0) {
            return;
        }
        Iterator iter = atts.keySet().iterator();
        while (iter.hasNext()) {
            QName qName = (QName)iter.next();
            String value = (String)atts.get(qName);
            this.setForeignAttribute(qName, value);
        }
    }

    public String getForeignAttributeValue(QName name) {
        if (this.foreignAttributes != null) {
            return (String)this.foreignAttributes.get(name);
        }
        return null;
    }

    public Map getForeignAttributes() {
        if (this.foreignAttributes != null) {
            return Collections.unmodifiableMap(this.foreignAttributes);
        }
        return Collections.EMPTY_MAP;
    }
}

