/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.firebase.database.annotations.Nullable;
import com.google.firebase.database.core.RepoInfo;
import com.google.firebase.database.utilities.ParsedUrl;
import com.google.firebase.database.utilities.Utilities;
import com.google.firebase.internal.FirebaseProcessEnvironment;

public final class EmulatorHelper {
    @VisibleForTesting
    public static final String FIREBASE_RTDB_EMULATOR_HOST_ENV_VAR = "FIREBASE_DATABASE_EMULATOR_HOST";

    private EmulatorHelper() {
    }

    public static String getEmulatorHostFromEnv() {
        return FirebaseProcessEnvironment.getenv(FIREBASE_RTDB_EMULATOR_HOST_ENV_VAR);
    }

    @VisibleForTesting
    @Nullable
    static boolean isEmulatorUrl(String databaseUrl) {
        if (Strings.isNullOrEmpty((String)databaseUrl)) {
            return false;
        }
        RepoInfo repoInfo = Utilities.parseUrl((String)databaseUrl).repoInfo;
        return !repoInfo.host.endsWith(".firebaseio.com") && databaseUrl.contains("ns=");
    }

    @Nullable
    public static String getEmulatorUrl(String suppliedDatabaseUrl, String emulatorHost) {
        if (EmulatorHelper.isEmulatorUrl(suppliedDatabaseUrl)) {
            return suppliedDatabaseUrl;
        }
        if (Strings.isNullOrEmpty((String)emulatorHost)) {
            return null;
        }
        if (emulatorHost.contains("http:") || emulatorHost.contains("?ns=")) {
            throw new IllegalArgumentException("emulator host declared in environment variable must be of the format \"host:port\"");
        }
        String namespaceName = "default";
        String path = "/";
        if (!Strings.isNullOrEmpty((String)suppliedDatabaseUrl)) {
            ParsedUrl parsedDbUrl = Utilities.parseUrl(suppliedDatabaseUrl);
            namespaceName = parsedDbUrl.repoInfo.namespace;
            path = parsedDbUrl.path.isEmpty() ? "/" : parsedDbUrl.path.toString() + "/";
        }
        return String.format("http://%s%s?ns=%s", emulatorHost, path, namespaceName);
    }
}

