/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class LambertCC9ZonesProjectionChoice
extends ListProjectionChoice {
    private static String[] lambert9zones = new String[]{I18n.tr("{0} ({1} to {2} degrees)", 1, 41, 43), I18n.tr("{0} ({1} to {2} degrees)", 2, 42, 44), I18n.tr("{0} ({1} to {2} degrees)", 3, 43, 45), I18n.tr("{0} ({1} to {2} degrees)", 4, 44, 46), I18n.tr("{0} ({1} to {2} degrees)", 5, 45, 47), I18n.tr("{0} ({1} to {2} degrees)", 6, 46, 48), I18n.tr("{0} ({1} to {2} degrees)", 7, 47, 49), I18n.tr("{0} ({1} to {2} degrees)", 8, 48, 50), I18n.tr("{0} ({1} to {2} degrees)", 9, 49, 51)};

    public LambertCC9ZonesProjectionChoice() {
        super(I18n.tr("Lambert CC9 Zone (France)", new Object[0]), "core:lambertcc9", lambert9zones, I18n.tr("Lambert CC Zone", new Object[0]));
    }

    @Override
    public JPanel getPreferencePanel(ActionListener listener) {
        return new LambertCC9CBPanel(this.entries, this.index, this.label, listener);
    }

    @Override
    public String getCurrentCode() {
        return "EPSG:" + Integer.toString(3942 + this.index);
    }

    @Override
    public String getProjectionName() {
        return I18n.tr("Lambert CC9 Zone (France)", new Object[0]);
    }

    @Override
    public String[] allCodes() {
        String[] codes = new String[9];
        for (int zone = 0; zone < 9; ++zone) {
            codes[zone] = "EPSG:" + (3942 + zone);
        }
        return codes;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String code) {
        if (code.startsWith("EPSG:39") && code.length() == 9) {
            try {
                String zonestring = code.substring(5, 9);
                int zoneval = Integer.parseInt(zonestring) - 3942;
                if (zoneval >= 0 && zoneval <= 8) {
                    return Collections.singleton(String.valueOf(zoneval + 1));
                }
            }
            catch (NumberFormatException ex) {
                Logging.warn(ex);
            }
        }
        return null;
    }

    @Override
    protected String indexToZone(int idx) {
        return Integer.toString(idx + 1);
    }

    @Override
    protected int zoneToIndex(String zone) {
        try {
            return Integer.parseInt(zone) - 1;
        }
        catch (NumberFormatException e) {
            Logging.warn(e);
            return this.defaultIndex;
        }
    }

    private static class LambertCC9CBPanel
    extends ListProjectionChoice.CBPanel {
        LambertCC9CBPanel(String[] entries, int initialIndex, String label, ActionListener listener) {
            super(entries, initialIndex, label, listener);
            this.add((Component)new JLabel(ImageProvider.get("data/projection", "LambertCC9Zones")), GBC.eol().fill(2));
            this.add(GBC.glue(1, 1), GBC.eol().fill(1));
        }
    }
}

