#
# Copyright (c) 2022-2024 Andrea Biscuola <a@abiscuola.com>
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#

# Program variables

set progname irctk
set progtitle IRCTk
set version 1.1.0-beta
set copyright "Copyright (c) 2022-2024"
set checkinterval 120000
set extproto 1.0
set timeout 256000
set backoffmin 2000
set backoffmax 120000
set bootpollingms 10
set exttimeoutms 3000
set logdir $::env(HOME)/irc/logs
set cfgdir $::env(HOME)/.config/$progname
set extdir /usr/local/libexec/$progname
set themedir /usr/local/share/irctk/themes
set defaulttheme $themedir/default/theme.tcl
set website "https://lab.abiscuola.com/irctk"
set defaultquit "Got to go. $::progname $::version"
set logging 1

# Protocol related stuffs

set msgsize 8703

# SDK file environment variables

set ::env(IRCTK_TCL_SDK) /usr/local/share/irctk/irctk-ext-sdk.tcl
set ::env(IRCTK_LOGS_PATH) $::env(HOME)/irc/logs

# Default colors and fonts

set colormention purple
set colormessage orange
set colorinfo blue
set colordefault black
set colorfounder "red"
set colorprotected "purple"
set coloroperator "green"
set colorhalfop "orange"
set colorvoice "blue"

set deffont TkDefaultFont