/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.Process;
import net.rubygrapefruit.platform.ProcessLauncher;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.WindowsRegistry;
import net.rubygrapefruit.platform.file.FileSystems;
import net.rubygrapefruit.platform.file.Files;
import net.rubygrapefruit.platform.file.PosixFiles;
import net.rubygrapefruit.platform.internal.DefaultProcessLauncher;
import net.rubygrapefruit.platform.memory.Memory;
import net.rubygrapefruit.platform.terminal.Terminals;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.temp.GradleUserHomeTemporaryFileProvider;
import org.gradle.fileevents.FileEvents;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.file.FileMetadataAccessor;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeintegration.NativeCapabilities;
import org.gradle.internal.nativeintegration.NativeIntegrationUnavailableException;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.FallbackConsoleDetector;
import org.gradle.internal.nativeintegration.console.NativePlatformConsoleDetector;
import org.gradle.internal.nativeintegration.console.TestOverrideConsoleDetector;
import org.gradle.internal.nativeintegration.console.WindowsConsoleDetector;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackFileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.services.FileSystemServices;
import org.gradle.internal.nativeintegration.filesystem.services.JdkFallbackHelper;
import org.gradle.internal.nativeintegration.filesystem.services.NativePlatformBackedFileMetadataAccessor;
import org.gradle.internal.nativeintegration.filesystem.services.UnavailablePosixFiles;
import org.gradle.internal.nativeintegration.jansi.JansiBootPathConfigurer;
import org.gradle.internal.nativeintegration.jna.UnsupportedEnvironment;
import org.gradle.internal.nativeintegration.network.HostnameLookup;
import org.gradle.internal.nativeintegration.processenvironment.NativePlatformBackedProcessEnvironment;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.util.internal.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeServices
implements ServiceRegistrationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeServices.class);
    private static NativeServices instance;
    private static final JansiBootPathConfigurer JANSI_BOOT_PATH_CONFIGURER;
    public static final String NATIVE_SERVICES_OPTION = "org.gradle.native";
    public static final String NATIVE_DIR_OVERRIDE = "org.gradle.native.dir";
    private final boolean useNativeIntegrations;
    private final File userHomeDir;
    private final Native nativeIntegration;
    private final EnumSet<NativeFeatures> enabledFeatures = EnumSet.noneOf(NativeFeatures.class);
    private final ServiceRegistry services;

    public static void initializeOnDaemon(File userHomeDir, NativeServicesMode mode) {
        NativeServices.initialize(userHomeDir, EnumSet.allOf(NativeFeatures.class), mode);
    }

    public static void initializeOnClient(File userHomeDir, NativeServicesMode mode) {
        NativeServices.initialize(userHomeDir, EnumSet.of(NativeFeatures.JANSI), mode);
    }

    public static void initializeOnWorker(File userHomeDir, NativeServicesMode mode) {
        NativeServices.initialize(userHomeDir, EnumSet.noneOf(NativeFeatures.class), mode);
    }

    public static void logFileSystemWatchingUnavailable(net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("File system watching is not available", (Throwable)ex);
        } else {
            LOGGER.info("File system watching is not available: {}", (Object)ex.getMessage());
        }
    }

    private static void initialize(File userHomeDir, EnumSet<NativeFeatures> requestedFeatures, NativeServicesMode mode) {
        NativeServices.checkNativeServicesMode(mode);
        if (instance == null) {
            try {
                instance = new NativeServices(userHomeDir, requestedFeatures, mode);
            }
            catch (RuntimeException e) {
                throw new ServiceCreationException("Could not initialize native services.", (Throwable)e);
            }
        }
    }

    private static void checkNativeServicesMode(NativeServicesMode mode) {
        if (mode != NativeServicesMode.ENABLED && mode != NativeServicesMode.DISABLED) {
            throw new IllegalArgumentException("Only explicit ENABLED or DISABLED mode is allowed for the NativeServices initialization, but was: " + (Object)((Object)mode));
        }
    }

    private NativeServices(File userHomeDir, EnumSet<NativeFeatures> requestedFeatures, NativeServicesMode mode) {
        this.userHomeDir = userHomeDir;
        boolean useNativeIntegrations = mode.isEnabled();
        Native nativeIntegration = null;
        File nativeBaseDir = NativeServices.getNativeServicesDir(userHomeDir).getAbsoluteFile();
        if (useNativeIntegrations) {
            try {
                nativeIntegration = Native.init((File)nativeBaseDir);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform is not available.", (Throwable)ex);
                useNativeIntegrations = false;
            }
            catch (NativeException ex) {
                if (ex.getCause() instanceof UnsatisfiedLinkError && ex.getCause().getMessage().toLowerCase(Locale.ROOT).contains("already loaded in another classloader")) {
                    LOGGER.debug("Unable to initialize native-platform. Failure: {}", (Object)NativeServices.format(ex));
                    useNativeIntegrations = false;
                }
                if (ex.getMessage().equals("Could not extract native JNI library.") && ex.getCause().getMessage().contains("native-platform.dll (The process cannot access the file because it is being used by another process)")) {
                    LOGGER.debug("Unable to initialize native-platform. Failure: {}", (Object)NativeServices.format(ex));
                    useNativeIntegrations = false;
                }
                throw ex;
            }
            LOGGER.info("Initialized native services in: {}", (Object)nativeBaseDir);
        }
        this.useNativeIntegrations = useNativeIntegrations;
        this.nativeIntegration = nativeIntegration;
        ServiceRegistryBuilder builder = ServiceRegistryBuilder.builder().displayName("native services").provider((ServiceRegistrationProvider)new FileSystemServices()).provider((ServiceRegistrationProvider)this).provider(new ServiceRegistrationProvider(){

            public void configure(ServiceRegistration registration) {
                registration.add(GradleUserHomeTemporaryFileProvider.class);
            }
        });
        for (NativeFeatures nativeFeature : NativeFeatures.values()) {
            if (requestedFeatures.contains((Object)nativeFeature) && nativeFeature.initialize(nativeBaseDir, builder, useNativeIntegrations)) {
                this.enabledFeatures.add(nativeFeature);
                continue;
            }
            nativeFeature.doWhenDisabled(builder);
        }
        this.services = builder.build();
    }

    private boolean isFeatureEnabled(NativeFeatures feature) {
        return this.enabledFeatures.contains((Object)feature);
    }

    private static File getNativeServicesDir(File userHomeDir) {
        String overrideProperty = NativeServices.getNativeDirOverride();
        if (overrideProperty == null) {
            return new File(userHomeDir, "native");
        }
        return new File(overrideProperty);
    }

    @Nullable
    private static String getNativeDirOverride() {
        return System.getProperty(NATIVE_DIR_OVERRIDE, System.getenv(NATIVE_DIR_OVERRIDE));
    }

    public static synchronized ServiceRegistry getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Cannot get an instance of NativeServices without first calling initialize().");
        }
        return NativeServices.instance.services;
    }

    @VisibleForTesting
    protected static synchronized Native getNative() {
        return ((NativeServices)Preconditions.checkNotNull((Object)NativeServices.instance)).nativeIntegration;
    }

    @Provides
    protected GradleUserHomeDirProvider createGradleUserHomeDirProvider() {
        return new GradleUserHomeDirProvider(){

            public File getGradleUserHomeDirectory() {
                return NativeServices.this.userHomeDir;
            }
        };
    }

    @Provides
    protected OperatingSystem createOperatingSystem() {
        return OperatingSystem.current();
    }

    @Provides
    protected Jvm createJvm() {
        return Jvm.current();
    }

    @Provides
    protected ProcessEnvironment createProcessEnvironment(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                Process process = (Process)this.nativeIntegration.get(Process.class);
                return new NativePlatformBackedProcessEnvironment(process);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform process integration is not available. Continuing with fallback.");
            }
        }
        return new UnsupportedEnvironment();
    }

    @Provides
    protected ConsoleDetector createConsoleDetector(OperatingSystem operatingSystem) {
        return new TestOverrideConsoleDetector(this.backingConsoleDetector(operatingSystem));
    }

    private ConsoleDetector backingConsoleDetector(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                Terminals terminals = (Terminals)this.nativeIntegration.get(Terminals.class);
                return new NativePlatformConsoleDetector(terminals);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                LOGGER.debug("Native-platform terminal integration is not available. Continuing with fallback.");
            }
            catch (NativeException ex) {
                LOGGER.debug("Unable to load from native-platform backed ConsoleDetector. Continuing with fallback. Failure: {}", (Object)NativeServices.format(ex));
            }
            try {
                if (operatingSystem.isWindows()) {
                    return new WindowsConsoleDetector();
                }
            }
            catch (LinkageError e) {
                LOGGER.debug("Unable to load native library. Continuing with fallback. Failure: {}", (Object)NativeServices.format(e));
            }
        }
        return new FallbackConsoleDetector();
    }

    @Provides
    protected WindowsRegistry createWindowsRegistry(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations && operatingSystem.isWindows()) {
            return (WindowsRegistry)this.nativeIntegration.get(WindowsRegistry.class);
        }
        return this.notAvailable(WindowsRegistry.class, operatingSystem);
    }

    @Provides
    public SystemInfo createSystemInfo(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                return (SystemInfo)this.nativeIntegration.get(SystemInfo.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform system info is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(SystemInfo.class, operatingSystem);
    }

    @Provides
    protected Memory createMemory(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                return (Memory)this.nativeIntegration.get(Memory.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform memory integration is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(Memory.class, operatingSystem);
    }

    @Provides
    protected ProcessLauncher createProcessLauncher() {
        if (this.useNativeIntegrations) {
            try {
                return (ProcessLauncher)this.nativeIntegration.get(ProcessLauncher.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform process launcher is not available. Continuing with fallback.");
            }
        }
        return new DefaultProcessLauncher();
    }

    @Provides
    protected PosixFiles createPosixFiles(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                return (PosixFiles)this.nativeIntegration.get(PosixFiles.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform posix files integration is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(UnavailablePosixFiles.class, operatingSystem);
    }

    @Provides
    protected HostnameLookup createHostnameLookup() {
        String hostname;
        if (this.useNativeIntegrations) {
            try {
                String hostname2 = ((SystemInfo)this.nativeIntegration.get(SystemInfo.class)).getHostname();
                return new FixedHostname(hostname2);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform posix files integration is not available. Continuing with fallback.");
            }
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = InetAddress.getLoopbackAddress().getHostAddress();
        }
        return new FixedHostname(hostname);
    }

    @Provides
    protected FileMetadataAccessor createFileMetadataAccessor(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                return new NativePlatformBackedFileMetadataAccessor((Files)this.nativeIntegration.get(Files.class));
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform files integration is not available. Continuing with fallback.");
            }
        }
        if (JavaVersion.current().isJava7Compatible()) {
            return JdkFallbackHelper.newInstanceOrFallback("org.gradle.internal.file.nio.NioFileMetadataAccessor", NativeServices.class.getClassLoader(), FallbackFileMetadataAccessor.class);
        }
        return new FallbackFileMetadataAccessor();
    }

    @Provides
    public NativeCapabilities createNativeCapabilities() {
        return new NativeCapabilities(){

            @Override
            public boolean useNativeIntegrations() {
                return NativeServices.this.useNativeIntegrations;
            }

            @Override
            public boolean useFileSystemWatching() {
                return NativeServices.this.isFeatureEnabled(NativeFeatures.FILE_SYSTEM_WATCHING);
            }
        };
    }

    @Provides
    protected FileSystems createFileSystems(OperatingSystem operatingSystem) {
        if (this.useNativeIntegrations) {
            try {
                return (FileSystems)this.nativeIntegration.get(FileSystems.class);
            }
            catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException e) {
                LOGGER.debug("Native-platform file systems information is not available. Continuing with fallback.");
            }
        }
        return this.notAvailable(FileSystems.class, operatingSystem);
    }

    private <T> T notAvailable(Class<T> type, OperatingSystem operatingSystem) {
        return (T)Cast.uncheckedNonnullCast((Object)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new BrokenService(type.getSimpleName(), this.useNativeIntegrations, operatingSystem)));
    }

    private static String format(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        builder.append(throwable);
        for (Throwable current = throwable.getCause(); current != null; current = current.getCause()) {
            builder.append(SystemProperties.getInstance().getLineSeparator());
            builder.append("caused by: ");
            builder.append(current);
        }
        return builder.toString();
    }

    static {
        JANSI_BOOT_PATH_CONFIGURER = new JansiBootPathConfigurer();
    }

    public static interface FileEventFunctionsProvider {
        public <T extends NativeIntegration> T getFunctions(Class<T> var1);
    }

    private static class FixedHostname
    implements HostnameLookup {
        private final String hostname;

        public FixedHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public String getHostname() {
            return this.hostname;
        }
    }

    private static class BrokenService
    implements InvocationHandler {
        private final String type;
        private final boolean useNativeIntegrations;
        private final OperatingSystem operatingSystem;

        private BrokenService(String type, boolean useNativeIntegrations, OperatingSystem operatingSystem) {
            this.type = type;
            this.useNativeIntegrations = useNativeIntegrations;
            this.operatingSystem = operatingSystem;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            throw new NativeIntegrationUnavailableException(String.format("Service '%s' is not available (os=%s, enabled=%s).", this.type, this.operatingSystem, this.useNativeIntegrations));
        }
    }

    public static enum NativeServicesMode {
        ENABLED{

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public boolean isPotentiallyEnabled() {
                return true;
            }
        }
        ,
        DISABLED{

            @Override
            public boolean isEnabled() {
                return false;
            }

            @Override
            public boolean isPotentiallyEnabled() {
                return false;
            }
        }
        ,
        NOT_SET{

            @Override
            public boolean isEnabled() {
                throw new UnsupportedOperationException("Cannot determine if native services are enabled or not for " + (Object)((Object)this) + " mode.");
            }

            @Override
            public boolean isPotentiallyEnabled() {
                return true;
            }
        };


        public abstract boolean isEnabled();

        public abstract boolean isPotentiallyEnabled();

        public static NativeServicesMode from(boolean isEnabled) {
            return isEnabled ? ENABLED : DISABLED;
        }

        public static NativeServicesMode fromSystemProperties() {
            return NativeServicesMode.fromString(System.getProperty(NativeServices.NATIVE_SERVICES_OPTION));
        }

        public static NativeServicesMode fromProperties(Map<String, String> properties) {
            return NativeServicesMode.fromString(properties.get(NativeServices.NATIVE_SERVICES_OPTION));
        }

        public static NativeServicesMode fromString(@Nullable String value) {
            value = (value == null ? "true" : value).trim();
            return NativeServicesMode.from(!"false".equalsIgnoreCase(value));
        }
    }

    public static enum NativeFeatures {
        FILE_SYSTEM_WATCHING{

            @Override
            public boolean initialize(File nativeBaseDir, ServiceRegistryBuilder builder, boolean useNativeIntegrations) {
                String version;
                if (!useNativeIntegrations) {
                    return false;
                }
                OperatingSystem operatingSystem = OperatingSystem.current();
                if (operatingSystem.isMacOsX() && VersionNumber.parse((String)(version = operatingSystem.getVersion())).getMajor() < 12) {
                    LOGGER.info("Disabling file system watching on macOS {}, as it is only supported for macOS 12+", (Object)version);
                    return false;
                }
                try {
                    final FileEvents fileEvents = FileEvents.init((File)nativeBaseDir);
                    LOGGER.info("Initialized file system watching services in: {}", (Object)nativeBaseDir);
                    builder.provider(new ServiceRegistrationProvider(){

                        @Provides
                        FileEventFunctionsProvider createFileEventFunctionsProvider() {
                            return new FileEventFunctionsProvider(){

                                @Override
                                public <T extends NativeIntegration> T getFunctions(Class<T> type) {
                                    if (fileEvents != null) {
                                        return (T)fileEvents.get(type);
                                    }
                                    throw new net.rubygrapefruit.platform.NativeIntegrationUnavailableException("File events are not available.");
                                }
                            };
                        }
                    });
                    return true;
                }
                catch (net.rubygrapefruit.platform.NativeIntegrationUnavailableException ex) {
                    NativeServices.logFileSystemWatchingUnavailable(ex);
                    return false;
                }
            }

            @Override
            public void doWhenDisabled(ServiceRegistryBuilder builder) {
                builder.provider(new ServiceRegistrationProvider(){

                    @Provides
                    FileEventFunctionsProvider createFileEventFunctionsProvider() {
                        return new FileEventFunctionsProvider(){

                            @Override
                            public <T extends NativeIntegration> T getFunctions(Class<T> type) {
                                throw new UnsupportedOperationException("File system watching is disabled.");
                            }
                        };
                    }
                });
            }
        }
        ,
        JANSI{

            @Override
            public boolean initialize(File nativeBaseDir, ServiceRegistryBuilder builder, boolean useNativeIntegrations) {
                JANSI_BOOT_PATH_CONFIGURER.configure(nativeBaseDir);
                LOGGER.info("Initialized jansi services in: {}", (Object)nativeBaseDir);
                return true;
            }

            @Override
            public void doWhenDisabled(ServiceRegistryBuilder builder) {
            }
        };


        public abstract boolean initialize(File var1, ServiceRegistryBuilder var2, boolean var3);

        public abstract void doWhenDisabled(ServiceRegistryBuilder var1);
    }
}

