/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet;

import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.i2p.data.DataHelper;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

public class I2PDefaultServlet
extends DefaultServlet {
    private ContextHandler _contextHandler;
    private boolean _dirAllowed = true;
    private Resource _resourceBase;
    private Resource _stylesheet;
    private static final String FORMAT = "yyyy-MM-dd HH:mm";

    public void init() throws UnavailableException {
        super.init();
        this._dirAllowed = this.getInitBoolean("dirAllowed", this._dirAllowed);
        String rb = this.getInitParameter("resourceBase");
        if (rb != null) {
            try {
                this._resourceBase = this._contextHandler.newResource(rb);
            }
            catch (Exception e) {
                throw new UnavailableException(e.toString());
            }
        }
        String css = this.getInitParameter("stylesheet");
        try {
            if (css != null) {
                this._stylesheet = Resource.newResource((String)css);
                if (!this._stylesheet.exists()) {
                    this._stylesheet = null;
                }
            }
            if (this._stylesheet == null) {
                this._stylesheet = Resource.newResource((URL)((Object)((Object)this)).getClass().getResource("/jetty-dir.css"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ContextHandler initContextHandler(ServletContext servletContext) {
        ContextHandler rv;
        this._contextHandler = rv = super.initContextHandler(servletContext);
        return rv;
    }

    private boolean getInitBoolean(String name, boolean dft) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return dft;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, String pathInContext) throws IOException {
        String dir;
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        byte[] data = null;
        String base = URIUtil.addPaths((String)request.getRequestURI(), (String)"/");
        if (this._resourceBase != null) {
            if (this._resourceBase instanceof ResourceCollection) {
                resource = this._resourceBase.addPath(pathInContext);
            }
        } else if (this._contextHandler.getBaseResource() instanceof ResourceCollection) {
            resource = this._contextHandler.getBaseResource().addPath(pathInContext);
        }
        if ((dir = I2PDefaultServlet.getListHTML(resource, base, pathInContext.length() > 1)) == null) {
            response.sendError(403, "No directory");
            return;
        }
        data = dir.getBytes("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }

    private static String getListHTML(Resource res, String base, boolean parent) throws IOException {
        if ((base = URIUtil.canonicalPath((String)base)) == null || !res.isDirectory()) {
            return null;
        }
        Object[] ls = res.list();
        if (ls == null) {
            return null;
        }
        DataHelper.sort((Object[])ls, (Comparator)new FileComparator(res));
        String decodedBase = URIUtil.decodePath((String)base);
        String title = "Directory: " + I2PDefaultServlet.deTag(decodedBase);
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<HTML><HEAD>");
        buf.append("<LINK HREF=\"").append("jetty-dir.css").append("\" REL=\"stylesheet\" TYPE=\"text/css\"/><TITLE>");
        buf.append(title);
        buf.append("</TITLE></HEAD><BODY>\n<H1>");
        buf.append(title);
        buf.append("</H1>\n<TABLE BORDER=0>\n");
        if (parent) {
            buf.append("<TR><TD><A HREF=\"");
            buf.append(URIUtil.addPaths((String)base, (String)"../"));
            buf.append("\">Parent Directory</A></TD><TD></TD><TD></TD></TR>\n");
        }
        String encodedBase = I2PDefaultServlet.hrefEncodeURI(base);
        SimpleDateFormat dfmt = new SimpleDateFormat(FORMAT, Locale.UK);
        TimeZone utc = TimeZone.getTimeZone("GMT");
        dfmt.setTimeZone(utc);
        for (int i = 0; i < ls.length; ++i) {
            Resource item;
            try {
                item = res.addPath((String)ls[i]);
            }
            catch (IOException ioe) {
                System.out.println("Skipping file in directory listing: " + ioe.getMessage());
                continue;
            }
            catch (RuntimeException re) {
                System.out.println("Skipping file in directory listing: " + re.getMessage());
                continue;
            }
            buf.append("\n<TR><TD><A HREF=\"");
            String path = URIUtil.addPaths((String)encodedBase, (String)URIUtil.encodePath((String)ls[i]));
            buf.append(path);
            boolean isDir = item.isDirectory();
            if (isDir && !path.endsWith("/")) {
                buf.append("/");
            }
            buf.append("\">");
            buf.append(I2PDefaultServlet.deTag((String)ls[i]));
            buf.append("</A></TD><TD ALIGN=right>");
            if (!isDir) {
                buf.append(item.length());
                buf.append(" bytes&nbsp;");
            }
            buf.append("</TD><TD>");
            if (!isDir) {
                buf.append(dfmt.format(new Date(item.lastModified())));
                buf.append(" UTC");
            }
            buf.append("</TD></TR>");
        }
        buf.append("</TABLE>\n");
        buf.append("</BODY></HTML>\n");
        return buf.toString();
    }

    private static String hrefEncodeURI(String raw) {
        char c;
        int i;
        StringBuffer buf = null;
        block9: for (i = 0; i < raw.length(); ++i) {
            c = raw.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '<': 
                case '>': {
                    buf = new StringBuffer(raw.length() << 1);
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (buf == null) {
            return raw;
        }
        block10: for (i = 0; i < raw.length(); ++i) {
            c = raw.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("%22");
                    continue block10;
                }
                case '\'': {
                    buf.append("%27");
                    continue block10;
                }
                case '<': {
                    buf.append("%3C");
                    continue block10;
                }
                case '>': {
                    buf.append("%3E");
                    continue block10;
                }
                default: {
                    buf.append(c);
                    continue block10;
                }
            }
        }
        return buf.toString();
    }

    private static String deTag(String raw) {
        return StringUtil.sanitizeXmlString((String)raw);
    }

    private static class FileComparator
    implements Comparator<String> {
        private final Comparator<Object> _coll;
        private final Resource _base;

        public FileComparator(Resource base) {
            this._base = base;
            this._coll = Collator.getInstance(Locale.US);
        }

        @Override
        public int compare(String a, String b) {
            try {
                Resource ra = this._base.addPath(a);
                Resource rb = this._base.addPath(b);
                boolean da = ra.isDirectory();
                boolean db = rb.isDirectory();
                if (da && !db) {
                    return -1;
                }
                if (!da && db) {
                    return 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this._coll.compare(a, b);
        }
    }
}

