/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.schema;

import java.util.Locale;
import java.util.Objects;

public interface Type {
    public static Type create(String type) {
        try {
            return Scalar.valueOf(type.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return new Named(Objects.requireNonNull(type));
        }
    }

    public static MapType create(Type keyType, Type valueType) {
        return new MapType(Objects.requireNonNull(keyType, "keyType"), Objects.requireNonNull(valueType, "valueType"));
    }

    public Kind kind();

    public static enum Scalar implements Type
    {
        ANY,
        BOOL,
        BYTES,
        DOUBLE,
        FLOAT,
        FIXED32,
        FIXED64,
        INT32,
        INT64,
        SFIXED32,
        SFIXED64,
        SINT32,
        SINT64,
        STRING,
        UINT32,
        UINT64;


        @Override
        public Kind kind() {
            return Kind.SCALAR;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }

    public static final class Named
    implements Type {
        private final String name;

        private Named(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        @Override
        public Kind kind() {
            return Kind.NAMED;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Named namedType = (Named)o;
            return Objects.equals(this.name, namedType.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static final class MapType
    implements Type {
        private final Type keyType;
        private final Type valueType;

        private MapType(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public Kind kind() {
            return Kind.MAP;
        }

        public Type keyType() {
            return this.keyType;
        }

        public Type valueType() {
            return this.valueType;
        }
    }

    public static enum Kind {
        SCALAR,
        MAP,
        NAMED;

    }
}

