/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ClientData;
import org.keycloak.provider.Provider;
import org.keycloak.sessions.AuthenticationSessionModel;

public interface LoginProtocol
extends Provider {
    public LoginProtocol setSession(KeycloakSession var1);

    public LoginProtocol setRealm(RealmModel var1);

    public LoginProtocol setUriInfo(UriInfo var1);

    public LoginProtocol setHttpHeaders(HttpHeaders var1);

    public LoginProtocol setEventBuilder(EventBuilder var1);

    public Response authenticated(AuthenticationSessionModel var1, UserSessionModel var2, ClientSessionContext var3);

    public Response sendError(AuthenticationSessionModel var1, Error var2, String var3);

    public ClientData getClientData(AuthenticationSessionModel var1);

    public Response sendError(ClientModel var1, ClientData var2, Error var3);

    public Response backchannelLogout(UserSessionModel var1, AuthenticatedClientSessionModel var2);

    public Response frontchannelLogout(UserSessionModel var1, AuthenticatedClientSessionModel var2);

    public Response finishBrowserLogout(UserSessionModel var1, AuthenticationSessionModel var2);

    public boolean requireReauthentication(UserSessionModel var1, AuthenticationSessionModel var2);

    default public boolean sendPushRevocationPolicyRequest(RealmModel realm, ClientModel resource, int notBefore, String managementUrl) {
        return false;
    }

    public static enum Error {
        CANCELLED_BY_USER,
        CANCELLED_AIA,
        CANCELLED_AIA_SILENT,
        ALREADY_LOGGED_IN,
        CONSENT_DENIED,
        PASSIVE_LOGIN_REQUIRED,
        PASSIVE_INTERACTION_REQUIRED;

    }
}

