/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import javax.swing.Action;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLdrActions;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MimeFactory<T extends DataObject>
implements DataObject.Factory {
    final Class<? extends T> clazz;
    final Constructor<? extends T> factory;
    final String mimeType;
    Image img;
    final FileObject fo;

    public MimeFactory(Class<? extends T> clazz, String string, Image image, FileObject fileObject) {
        this.clazz = clazz;
        this.mimeType = string;
        this.img = image;
        try {
            this.factory = clazz.getConstructor(FileObject.class, MultiFileLoader.class);
            this.factory.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw (IllegalStateException)new IllegalStateException(noSuchMethodException.getMessage()).initCause(noSuchMethodException);
        }
        this.fo = fileObject;
    }

    public static MimeFactory<DataObject> layer(FileObject fileObject) throws ClassNotFoundException {
        String string = (String)fileObject.getAttribute("dataObjectClass");
        if (string == null) {
            throw new IllegalStateException("No attribute dataObjectClass for " + fileObject);
        }
        String string2 = (String)fileObject.getAttribute("mimeType");
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = MimeFactory.class.getClassLoader();
        }
        Class<DataObject> clazz = classLoader.loadClass(string).asSubclass(DataObject.class);
        return new MimeFactory<DataObject>(clazz, string2, null, fileObject);
    }

    @Override
    public DataObject findDataObject(FileObject fileObject, Set<? super FileObject> set) throws IOException {
        DataObject dataObject = null;
        Exception exception = null;
        try {
            dataObject = (DataObject)this.factory.newInstance(fileObject, DataLoaderPool.getDefaultFileLoader());
        }
        catch (InstantiationException instantiationException) {
            exception = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof IOException) {
                throw (IOException)invocationTargetException.getTargetException();
            }
            exception = invocationTargetException;
        }
        if (dataObject == null) {
            throw (IOException)new IOException(exception.getMessage()).initCause(exception);
        }
        if (dataObject instanceof MultiDataObject) {
            MultiDataObject multiDataObject = (MultiDataObject)dataObject;
            multiDataObject.getCookieSet().assign(DataObject.Factory.class, (Object[])new DataObject.Factory[]{this});
        }
        return dataObject;
    }

    final Image getImage(int n) {
        if (this.img == null && this.fo != null) {
            this.img = ImageUtilities.loadImage((String)"org/openide/loaders/empty.gif", (boolean)true);
            try {
                this.img = this.fo.getFileSystem().getStatus().annotateIcon(this.img, n, Collections.singleton(this.fo));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        return this.img;
    }

    final Action[] getActions() {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Loaders/" + this.mimeType + "/Actions");
        if (fileObject != null) {
            DataFolder dataFolder = DataFolder.findFolder(fileObject);
            try {
                return (Action[])new DataLdrActions(dataFolder, null).instanceCreate();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Exceptions.printStackTrace((Throwable)classNotFoundException);
            }
        }
        return DataLoaderPool.getDefaultFileLoader().getSwingActions();
    }
}

