/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server;

import java.io.File;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.option.FileOption;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.util.test.FreeColTestCase;

public class SaveLoadTest
extends FreeColTestCase {
    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServer();
        super.tearDown();
    }

    public void testDelayedLoading() {
        File file = ServerTestHelper.createRandomSaveGame();
        ServerTestHelper.stopServer();
        FreeColServer server = ServerTestHelper.startServer(false, true);
        try {
            server.loadGame(new FreeColSavegameFile(file));
        }
        catch (Exception e) {
            e.printStackTrace();
            SaveLoadTest.fail((String)e.getMessage());
        }
        SaveLoadTest.assertNotNull((Object)server.getGame());
        SaveLoadTest.assertNotNull((Object)server.getGame().getMap());
        file.delete();
        SaveLoadTest.assertFalse((boolean)file.exists());
    }

    public void testImmediateLoading() {
        File file = ServerTestHelper.createRandomSaveGame();
        ServerTestHelper.stopServer();
        FreeColServer server = ServerTestHelper.startServer(file, false, true);
        SaveLoadTest.assertNotNull((Object)server.getGame());
        SaveLoadTest.assertNotNull((Object)server.getGame().getMap());
        file.delete();
        SaveLoadTest.assertFalse((boolean)file.exists());
    }

    public void testImport() {
        File file = ServerTestHelper.createRandomSaveGame();
        ServerTestHelper.stopServer();
        FreeColServer server = ServerTestHelper.startServer(false, true);
        FileOption importOption = server.getSpecification().getMapGeneratorOptions().getOption("model.option.importFile", FileOption.class);
        importOption.setValue(file);
        try {
            server.startGame();
        }
        catch (FreeColException e) {
            SaveLoadTest.fail((String)e.getMessage());
        }
        importOption.setValue(null);
        SaveLoadTest.assertEquals((Object)((Object)FreeColServer.ServerState.IN_GAME), (Object)((Object)server.getServerState()));
        SaveLoadTest.assertNotNull((Object)server.getGame());
        SaveLoadTest.assertNotNull((Object)server.getGame().getMap());
        file.delete();
        SaveLoadTest.assertFalse((boolean)file.exists());
    }
}

