/*
 * Decompiled with CFR 0.152.
 */
package gnu.commonlisp.lang;

import gnu.commonlisp.lang.CommonLisp;
import gnu.expr.Keyword;
import gnu.kawa.lispexpr.LispPackage;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.lists.Pair;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.Values;
import gnu.text.Lexer;
import gnu.text.SyntaxException;
import java.io.IOException;

class SharpPlus
extends ReadTableEntry {
    static Keyword OR = Keyword.make("or");
    static Keyword AND = Keyword.make("and");
    static Keyword NOT = Keyword.make("not");

    SharpPlus() {
    }

    @Override
    public Object read(Lexer in, int ch, int count) throws IOException, SyntaxException {
        boolean skip;
        LispReader r = (LispReader)in;
        Object exp = SharpPlus.readFeatureExpression(r);
        boolean featurep = SharpPlus.featurep(exp);
        boolean bl = ch == 45 ? featurep : (skip = !featurep);
        if (skip) {
            r.readObject();
        }
        return Values.empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object readFeatureExpression(LispReader reader) throws IOException, SyntaxException {
        ThreadLocation<LispPackage> pkg = LispPackage.currentPackage;
        Object old = pkg.setWithSave(LispPackage.KeywordNamespace);
        try {
            Object object2 = reader.readObject();
            return object2;
        }
        finally {
            pkg.setRestore(old);
        }
    }

    static boolean featurep(Object exp) {
        if (exp instanceof Symbol) {
            return CommonLisp.features.get().contains(exp);
        }
        if (exp instanceof Pair) {
            Pair pair = (Pair)exp;
            Object head = pair.getCar();
            Object tail = pair.getCdr();
            if (head == OR || head == AND) {
                while (tail instanceof Pair) {
                    pair = (Pair)tail;
                    boolean val = SharpPlus.featurep(pair.getCar());
                    if (val == (head == OR)) {
                        return val;
                    }
                    tail = pair.getCdr();
                }
                if (tail == Pair.Empty) {
                    return head == AND;
                }
            } else if (head == NOT && tail instanceof Pair && (pair = (Pair)tail).getCdr() == Pair.Empty) {
                return !SharpPlus.featurep(pair.getCar());
            }
        }
        throw new RuntimeException("invalid feature expression: " + exp);
    }
}

