/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.httpcomponents.hc5;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientContext;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationConvention;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationDocumentation;
import java.io.IOException;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;

public class DefaultApacheHttpClientObservationConvention
implements ApacheHttpClientObservationConvention {
    public static final DefaultApacheHttpClientObservationConvention INSTANCE = new DefaultApacheHttpClientObservationConvention();
    private static final String CONTEXTUAL_NAME_UNKNOWN = "HTTP UNKNOWN";
    private static final KeyValue METHOD_UNKNOWN = ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.METHOD.withValue("UNKNOWN");
    private static final KeyValue URI_UNKNOWN = ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI.withValue("UNKNOWN");
    private static final KeyValue STATUS_IO_ERROR = ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS.withValue("IO_ERROR");
    private static final KeyValue STATUS_CLIENT_ERROR = ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS.withValue("CLIENT_ERROR");
    private static final KeyValue EXCEPTION_NONE = ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.EXCEPTION.withValue("none");
    private static final KeyValue OUTCOME_UNKNOWN = ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.OUTCOME.withValue(Outcome.UNKNOWN.name());
    private static final KeyValue TARGET_HOST_UNKNOWN = ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_HOST.withValue("UNKNOWN");
    private static final KeyValue TARGET_PORT_UNKNOWN = ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_PORT.withValue("UNKNOWN");
    private static final KeyValue TARGET_SCHEME_UNKNOWN = ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_SCHEME.withValue("UNKNOWN");

    protected DefaultApacheHttpClientObservationConvention() {
    }

    public String getName() {
        return "httpcomponents.httpclient.request";
    }

    public String getContextualName(ApacheHttpClientContext context) {
        HttpRequest request = (HttpRequest)context.getCarrier();
        if (request != null && request.getMethod() != null) {
            return "HTTP " + request.getMethod();
        }
        return CONTEXTUAL_NAME_UNKNOWN;
    }

    public KeyValues getLowCardinalityKeyValues(ApacheHttpClientContext context) {
        return KeyValues.of(this.exception(context), this.method(context), this.outcome(context), this.status(context), this.targetHost(context), this.targetPort(context), this.targetScheme(context), this.uri(context));
    }

    protected KeyValue exception(ApacheHttpClientContext context) {
        Throwable error = context.getError();
        if (error != null) {
            return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.EXCEPTION.withValue(error.getClass().getSimpleName());
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue method(ApacheHttpClientContext context) {
        HttpRequest request = (HttpRequest)context.getCarrier();
        if (request == null || request.getMethod() == null) {
            return METHOD_UNKNOWN;
        }
        return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.METHOD.withValue(request.getMethod());
    }

    protected KeyValue outcome(ApacheHttpClientContext context) {
        HttpResponse response = (HttpResponse)context.getResponse();
        if (response == null) {
            return OUTCOME_UNKNOWN;
        }
        return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.OUTCOME.withValue(Outcome.forStatus(response.getCode()).name());
    }

    protected KeyValue status(ApacheHttpClientContext context) {
        Throwable error = context.getError();
        if (error instanceof IOException || error instanceof HttpException || error instanceof RuntimeException) {
            return STATUS_IO_ERROR;
        }
        HttpResponse response = (HttpResponse)context.getResponse();
        if (response == null) {
            return STATUS_CLIENT_ERROR;
        }
        return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS.withValue(String.valueOf(response.getCode()));
    }

    protected KeyValue targetHost(ApacheHttpClientContext context) {
        RouteInfo httpRoute = DefaultApacheHttpClientObservationConvention.getHttpRoute(context);
        if (httpRoute != null) {
            return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_HOST.withValue(httpRoute.getTargetHost().getHostName());
        }
        return TARGET_HOST_UNKNOWN;
    }

    protected KeyValue targetPort(ApacheHttpClientContext context) {
        RouteInfo httpRoute = DefaultApacheHttpClientObservationConvention.getHttpRoute(context);
        if (httpRoute != null) {
            int port = httpRoute.getTargetHost().getPort();
            return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_PORT.withValue(String.valueOf(port));
        }
        return TARGET_PORT_UNKNOWN;
    }

    protected KeyValue targetScheme(ApacheHttpClientContext context) {
        RouteInfo httpRoute = DefaultApacheHttpClientObservationConvention.getHttpRoute(context);
        if (httpRoute != null) {
            return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_SCHEME.withValue(httpRoute.getTargetHost().getSchemeName());
        }
        return TARGET_SCHEME_UNKNOWN;
    }

    @Nullable
    private static RouteInfo getHttpRoute(ApacheHttpClientContext context) {
        return context.getHttpClientContext().getHttpRoute();
    }

    protected KeyValue uri(ApacheHttpClientContext context) {
        HttpClientContext clientContext = context.getHttpClientContext();
        String uriTemplate = (String)clientContext.getAttribute("micrometer.uri.template");
        if (uriTemplate != null) {
            return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI.withValue(uriTemplate);
        }
        if (context.getCarrier() != null) {
            return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI.withValue(context.getUriMapper().apply((HttpRequest)context.getCarrier()));
        }
        return URI_UNKNOWN;
    }

    @Deprecated
    Outcome getStatusOutcome(@Nullable HttpResponse response) {
        return response != null ? Outcome.forStatus(response.getCode()) : Outcome.UNKNOWN;
    }

    @Deprecated
    String getStatusValue(@Nullable HttpResponse response, Throwable error) {
        if (error instanceof IOException || error instanceof HttpException || error instanceof RuntimeException) {
            return "IO_ERROR";
        }
        return response != null ? Integer.toString(response.getCode()) : "CLIENT_ERROR";
    }

    @Deprecated
    String getMethodString(@Nullable HttpRequest request) {
        return request != null && request.getMethod() != null ? request.getMethod() : "UNKNOWN";
    }
}

