/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * cross(vec3(-0.03, -0.85, -0.94), vec3(-0.03, -0.85, -0.94)) => vec3(0.0, 0.0, 0.0)
 * cross(vec3(-0.03, -0.85, -0.94), vec3(1.67, 0.66, 1.87)) => vec3(-0.9691, -1.5137, 1.3997)
 * cross(vec3(1.67, 0.66, 1.87), vec3(-0.03, -0.85, -0.94)) => vec3(0.9691, 1.5137, -1.3997)
 * cross(vec3(1.67, 0.66, 1.87), vec3(1.67, 0.66, 1.87)) => vec3(0.0, 0.0, 0.0)
 */
#version 120

void main()
{
  float[distance(cross(vec3(-0.03, -0.85, -0.94), vec3(-0.03, -0.85, -0.94)), vec3(0.0, 0.0, 0.0)) <= 1.607e-05 ? 1 : -1] array0;
  float[distance(cross(vec3(-0.03, -0.85, -0.94), vec3(1.67, 0.66, 1.87)), vec3(-0.9691, -1.5137, 1.3997)) <= 3.2865315e-05 ? 1 : -1] array1;
  float[distance(cross(vec3(1.67, 0.66, 1.87), vec3(-0.03, -0.85, -0.94)), vec3(0.9691, 1.5137, -1.3997)) <= 3.2865315e-05 ? 1 : -1] array2;
  float[distance(cross(vec3(1.67, 0.66, 1.87), vec3(1.67, 0.66, 1.87)), vec3(0.0, 0.0, 0.0)) <= 6.7213994e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
