/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.netbeans.spi.search.SearchScopeDefinitionProvider;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public class SearchScopeList {
    private final List<SearchScopeDefinition> scopes;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);
    private ProxyChangeListener proxyChangeListener = new ProxyChangeListener();

    public SearchScopeList(SearchScopeDefinition ... searchScopeDefinitionArray) {
        this.scopes = this.createScopeList(searchScopeDefinitionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        List<Object> list = this.scopes;
        synchronized (list) {
            for (SearchScopeDefinition searchScopeDefinition : this.scopes) {
                searchScopeDefinition.removeChangeListener(this.proxyChangeListener);
                searchScopeDefinition.clean();
            }
            this.scopes.clear();
        }
        list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(changeListener);
        }
    }

    private List<SearchScopeDefinition> createScopeList(SearchScopeDefinition ... searchScopeDefinitionArray) {
        ArrayList<SearchScopeDefinition> arrayList = new ArrayList<SearchScopeDefinition>(6);
        Collection collection = Lookup.getDefault().lookupAll(SearchScopeDefinitionProvider.class);
        for (SearchScopeDefinitionProvider object : collection) {
            arrayList.addAll(object.createSearchScopeDefinitions());
        }
        arrayList.addAll(Arrays.asList(searchScopeDefinitionArray));
        arrayList.sort(new ScopePriorityComparator());
        for (SearchScopeDefinition searchScopeDefinition : arrayList) {
            searchScopeDefinition.addChangeListener(this.proxyChangeListener);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchScopeDefinition> getSeachScopeDefinitions() {
        List<SearchScopeDefinition> list = this.scopes;
        synchronized (list) {
            return new ArrayList<SearchScopeDefinition>(this.scopes);
        }
    }

    private class ProxyChangeListener
    implements ChangeListener {
        private ProxyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Mutex.EVENT.writeAccess(() -> this.notifyDelegates(changeEvent));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyDelegates(ChangeEvent changeEvent) {
            List list = SearchScopeList.this.changeListeners;
            synchronized (list) {
                for (ChangeListener changeListener : SearchScopeList.this.changeListeners) {
                    changeListener.stateChanged(changeEvent);
                }
            }
        }
    }

    private class ScopePriorityComparator
    implements Comparator<SearchScopeDefinition> {
        private ScopePriorityComparator() {
        }

        @Override
        public int compare(SearchScopeDefinition searchScopeDefinition, SearchScopeDefinition searchScopeDefinition2) {
            return searchScopeDefinition.getPriority() - searchScopeDefinition2.getPriority();
        }
    }
}

