/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.jdkspecific;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.spi.URLStreamHandlerProvider;

public class ClasspathURLStreamHandlerProvider
extends URLStreamHandlerProvider {
    private final boolean skipProvider = Boolean.getBoolean("org.infinispan.urlstreamhandler.skip");

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (!this.skipProvider && "classpath".equals(protocol)) {
            return new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    URL resource;
                    String path = u.getPath();
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    URL uRL = resource = classLoader == null ? null : classLoader.getResource(path);
                    if (resource == null) {
                        resource = ClassLoader.getSystemClassLoader().getResource(path);
                    }
                    if (resource != null) {
                        return resource.openConnection();
                    }
                    throw new FileNotFoundException(u.toString());
                }
            };
        }
        return null;
    }
}

