/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.maven;

import java.io.IOException;
import java.nio.file.Path;
import org.infinispan.commons.maven.LocalArtifact;
import org.infinispan.commons.maven.MavenArtifact;
import org.infinispan.commons.maven.URLArtifact;

public interface Artifact {
    public static Artifact fromString(String name) {
        if (name.startsWith("http://") || name.startsWith("https://") || name.startsWith("file://") || name.startsWith("ftp://")) {
            return new URLArtifact(name);
        }
        if (MavenArtifact.isMavenArtifact(name)) {
            return MavenArtifact.fromString(name);
        }
        return new LocalArtifact(name);
    }

    public Path resolveArtifact() throws IOException;

    public Artifact verbose(boolean var1);

    public Artifact force(boolean var1);
}

