/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.table;

import ca.sqlpower.swingui.table.FormatFactory;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class PercentTableCellRenderer
extends DefaultTableCellRenderer
implements FormatFactory {
    DecimalFormat pctFormat = new DecimalFormat("0.00%");
    private final boolean includePercentSign;
    public Format fakeFormatter = new Format(){

        @Override
        public StringBuffer format(Object value, StringBuffer toAppendTo, FieldPosition pos) {
            if (value instanceof Number) {
                String formattedValue = PercentTableCellRenderer.this.pctFormat.format(value);
                if (!PercentTableCellRenderer.this.includePercentSign) {
                    formattedValue = formattedValue.replace("%", "");
                }
                return toAppendTo.append(formattedValue);
            }
            throw new IllegalArgumentException("Value must be a Number object");
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException("This formatter cannot parse");
        }
    };

    public PercentTableCellRenderer() {
        this(true);
    }

    public PercentTableCellRenderer(boolean includePercentSign) {
        this.includePercentSign = includePercentSign;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String formattedValue;
        if (value == null) {
            formattedValue = "N/A";
        } else {
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException("Value must be a Number object");
            }
            formattedValue = this.pctFormat.format(value);
            if (!this.includePercentSign) {
                formattedValue = formattedValue.replace("%", "");
            }
        }
        return super.getTableCellRendererComponent(table, formattedValue, isSelected, hasFocus, row, column);
    }

    @Override
    public Format getFormat() {
        return this.fakeFormatter;
    }
}

