/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;

public class PrimitiveTypeUtil {
    public static Type getPrimitiveTypeFromDescriptor(String descriptor) {
        int dimension = 0;
        while (descriptor.charAt(dimension) == '[') {
            ++dimension;
        }
        if (dimension == 0) {
            return PrimitiveType.getPrimitiveType(descriptor.charAt(dimension));
        }
        return new ObjectType(descriptor.substring(dimension), dimension);
    }

    public static PrimitiveType getPrimitiveTypeFromValue(int value) {
        if (value >= 0) {
            if (value <= 1) {
                return PrimitiveType.MAYBE_BOOLEAN_TYPE;
            }
            if (value <= 127) {
                return PrimitiveType.MAYBE_BYTE_TYPE;
            }
            if (value <= Short.MAX_VALUE) {
                return PrimitiveType.MAYBE_SHORT_TYPE;
            }
            if (value <= 65535) {
                return PrimitiveType.MAYBE_CHAR_TYPE;
            }
        } else {
            if (value >= -128) {
                return PrimitiveType.MAYBE_NEGATIVE_BYTE_TYPE;
            }
            if (value >= Short.MIN_VALUE) {
                return PrimitiveType.MAYBE_NEGATIVE_SHORT_TYPE;
            }
        }
        return PrimitiveType.MAYBE_INT_TYPE;
    }

    public static PrimitiveType getCommonPrimitiveType(PrimitiveType pt1, PrimitiveType pt2) {
        return PrimitiveTypeUtil.getPrimitiveTypeFromFlags(pt1.getFlags() & pt2.getFlags());
    }

    public static PrimitiveType getPrimitiveTypeFromFlags(int flags) {
        switch (flags) {
            case 1: {
                return PrimitiveType.TYPE_BOOLEAN;
            }
            case 2: {
                return PrimitiveType.TYPE_CHAR;
            }
            case 4: {
                return PrimitiveType.TYPE_FLOAT;
            }
            case 8: {
                return PrimitiveType.TYPE_DOUBLE;
            }
            case 16: {
                return PrimitiveType.TYPE_BYTE;
            }
            case 32: {
                return PrimitiveType.TYPE_SHORT;
            }
            case 64: {
                return PrimitiveType.TYPE_INT;
            }
            case 128: {
                return PrimitiveType.TYPE_LONG;
            }
            case 256: {
                return PrimitiveType.TYPE_VOID;
            }
        }
        if (flags == 66) {
            return PrimitiveType.MAYBE_CHAR_TYPE;
        }
        if (flags == 98) {
            return PrimitiveType.MAYBE_SHORT_TYPE;
        }
        if (flags == 114) {
            return PrimitiveType.MAYBE_BYTE_TYPE;
        }
        if (flags == 115) {
            return PrimitiveType.MAYBE_BOOLEAN_TYPE;
        }
        if (flags == 112) {
            return PrimitiveType.MAYBE_NEGATIVE_BYTE_TYPE;
        }
        if (flags == 96) {
            return PrimitiveType.MAYBE_NEGATIVE_SHORT_TYPE;
        }
        if (flags == 113) {
            return PrimitiveType.MAYBE_NEGATIVE_BOOLEAN_TYPE;
        }
        return null;
    }

    public static Type getPrimitiveTypeFromTag(int tag) {
        switch (tag) {
            case 4: {
                return PrimitiveType.TYPE_BOOLEAN;
            }
            case 5: {
                return PrimitiveType.TYPE_CHAR;
            }
            case 6: {
                return PrimitiveType.TYPE_FLOAT;
            }
            case 7: {
                return PrimitiveType.TYPE_DOUBLE;
            }
            case 8: {
                return PrimitiveType.TYPE_BYTE;
            }
            case 9: {
                return PrimitiveType.TYPE_SHORT;
            }
            case 10: {
                return PrimitiveType.TYPE_INT;
            }
            case 11: {
                return PrimitiveType.TYPE_LONG;
            }
        }
        assert (false);
        return null;
    }
}

