/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.util.logging.Logger;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import tr.model.project.Project;
import tr.view.projects.ExpandAllCookie;

public class ExpandAllAction
extends CookieAction {
    private static final Logger LOG = Logger.getLogger("tr.view.projects");
    private TreeView treeView;

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ExpandAllAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Class[] cookieClasses() {
        return new Class[]{Project.class};
    }

    public int mode() {
        return 4;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodes) {
        if (nodes == null || nodes.length < 1) {
            LOG.fine("No nodes to action.");
            return;
        }
        ExpandAllCookie cookie = (ExpandAllCookie)nodes[0].getCookie(ExpandAllCookie.class);
        if (cookie == null) {
            LOG.fine("ExpandAll cookie not found.");
            return;
        }
        this.treeView = cookie.getTreeView();
        LOG.fine("Expanding.");
        this.expand(nodes);
    }

    private void expand(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            this.treeView.expandNode(nodes[i]);
            this.expand(nodes[i].getChildren().getNodes());
        }
    }
}

