/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.atrules.css.media;

import org.w3c.css.atrules.css.media.MediaFeature;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssComparator;
import org.w3c.css.values.CssValue;

public abstract class MediaRangeFeature
extends MediaFeature {
    public CssValue value;
    public CssValue otherValue;
    public String comparator;
    public String otherComparator;
    public String modifier;
    public boolean comparatorNameFirst = true;

    public static void checkComparators(ApplContext ac, CssComparator c1, CssComparator c2, String caller) throws InvalidParamException {
        if (!CssComparator.checkCompatibility(c1, c2)) {
            throw new InvalidParamException("comparator", c1, c2, ac);
        }
        if (!CssComparator.checkUsefulness(c1, c2)) {
            ac.getFrame().addWarning("comparator", new String[]{c1.toString(), c2.toString()});
        }
    }

    public void setModifier(ApplContext ac, String modifier) throws InvalidParamException {
        this.modifier = modifier;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return this.getFeatureName();
        }
        StringBuilder sb = new StringBuilder();
        if (this.modifier != null) {
            sb.append(this.modifier).append('-');
            sb.append(this.getFeatureName());
            sb.append(':').append(' ').append(this.value.toString());
        } else if (this.comparator != null) {
            if (this.otherComparator == null) {
                if (this.comparatorNameFirst) {
                    sb.append(this.getFeatureName()).append(' ').append(this.comparator).append(' ');
                    sb.append(this.value);
                } else {
                    sb.append(this.value).append(' ').append(this.comparator).append(' ');
                    sb.append(this.getFeatureName());
                }
            } else {
                sb.append(this.value).append(' ').append(this.comparator).append(' ');
                sb.append(this.getFeatureName());
                sb.append(' ').append(this.otherComparator).append(' ');
                sb.append(this.otherValue);
            }
        } else {
            sb.append(this.getFeatureName());
            sb.append(':').append(' ').append(this.value.toString());
        }
        return sb.toString();
    }
}

